﻿
using System;
using System.Text;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Graphics;

namespace XELF.Sphynx {

	class GameStatus {
		public int Score;
		public int Time;

		public void Reset() {
			Score = 0;
			Time = 0;
		}
		public void Win() {
			Score += 10000 / (1 + Time);
		}
		public void Update() {
			Time = Math.Min(MaximumTime, Time + 1);
		}
		public const int MaximumTime = 9999 * 60 * 60 + 59 * 60 + 59;
	}

	/// <summary>
	/// 時間とスコアの表示
	/// </summary>
	class ScoreDisplay : DrawableGameComponent {
		SpriteBatch spriteBatch;
		SpriteFont font;
		readonly StringBuilder text = new StringBuilder();
		Vector2 foreLocation = new Vector2(0x380, 0x40);
		Vector2 shadowLocation = new Vector2(0x380 + 2, 0x40 + 2);
		public GameStatus Status;

		public ScoreDisplay(Game game)
			: base(game) {
		}

		protected override void LoadContent() {
			spriteBatch = new SpriteBatch(GraphicsDevice);
			font = Game.Content.Load<SpriteFont>("BigFont");
			base.LoadContent();
		}

		public override void Update(GameTime gameTime) {
			Status.Update();
			text.Clear();
			text.AppendFormat("TIME {0:D04}:{1:D02}'{2:D02}\nSCORE {3:D08}",
				(Status.Time / (60 * 60)) % 60, (Status.Time / 60) % 60, Status.Time % 60,
				Status.Score);
			base.Update(gameTime);
		}

		public override void Draw(GameTime gameTime) {
			spriteBatch.Begin();
			spriteBatch.DrawString(font, text, shadowLocation, Color.Black);
			spriteBatch.DrawString(font, text, foreLocation, Color.White);
			spriteBatch.End();
			base.Draw(gameTime);
		}
	}

}
