﻿using System;
using System.Text;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Graphics;

namespace XELF.Sphynx {

	/// <summary>
	/// ポップアップメッセージ表示
	/// </summary>
	class Popup {
		public readonly StringBuilder Text = new StringBuilder();
		public Vector2 Offset;
		public bool Enabled { get; private set; }

		/// <summary>
		/// ポップアップ表示が終わり、待ち時間を消化した。
		/// </summary>
		public event EventHandler Finished;

		readonly GraphicsDevice GraphicsDevice;
		readonly SpriteBatch spriteBatch;
		readonly SpriteFont font;
		int wait;

		public string TextString {
			get { return Text.ToString(); }
			set { Text.Clear(); Text.Append(value); }
		}

		public Popup(GraphicsDevice graphicsDevice, SpriteFont font) {
			GraphicsDevice = graphicsDevice;
			this.font = font;
			spriteBatch = new SpriteBatch(graphicsDevice);
			Inactivate();
		}

		public void Draw() {
			if (Enabled) {
				spriteBatch.Begin();
				var position = (new Vector2(GraphicsDevice.Viewport.Width, GraphicsDevice.Viewport.Height)
					- font.MeasureString(Text)) * 0.5f;
				Vector2.Add(ref position, ref Offset, out position);
				position.X -= (float)(position.X % 1);
				position.Y -= (float)(position.Y % 1);
				var shadowPosition = position;
				shadowPosition.X += 2;
				shadowPosition.Y += 2;
				spriteBatch.DrawString(font, Text, shadowPosition, Color.Black);
				spriteBatch.DrawString(font, Text, position, Color.White);
				spriteBatch.End();
			}
		}

		public void Inactivate() {
			Enabled = false;
			wait = 0;
		}
		public void Activate() {
			if (!Enabled) {
				wait = 5 * 60;
				Enabled = true;
			}
		}
		public void Update() {
			if (wait > 0) {
				wait--;
				if (wait == 0) {
					if (Finished != null)
						Finished(this, EventArgs.Empty);
				}
			}
		}
	}

}
