﻿
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Graphics;

namespace XELF.Sphynx {

	class PointerDisplay : DrawableGameComponent {
		readonly VectorGraphicsComponent graphics;
		readonly CameraComponent cameraComponent;
		MouseInput input;
		Texture2D texture;
		SpriteBatch spriteBatch;

		public PointerDisplay(Game game, VectorGraphicsComponent graphics,
			MouseInput input, CameraComponent cameraComponent)
			: base(game) {
			this.graphics = graphics;
			this.input = input;
			this.cameraComponent = cameraComponent;
		}
		protected override void LoadContent() {
			spriteBatch = new SpriteBatch(GraphicsDevice);
			texture = Game.Content.Load<Texture2D>("Gimmick");
			this.Camera = cameraComponent.Camera;
			base.LoadContent();
		}

		public override void Draw(GameTime gameTime) {
			graphics.Batch.Begin();
			graphics.Batch.DrawIcon(IconKind.Cursor, WorldPositionFrom(input.Location), Color.White, 1.0f);
			graphics.Batch.End();
			base.Draw(gameTime);
		}

		public Camera Camera {
			get;
			protected set;
		}

		Vector3 WorldPositionFrom(Vector2 location) {
			Vector3 position = GraphicsDevice.Viewport.Unproject(
				new Vector3(location, 0), Camera.Projection, Camera.View, Camera.World);
			return position;
		}
	}

}