﻿using System;

namespace XELF.Sphynx {

	interface Operator {
		bool Active { get; set; }
	}
	class Operand : Operator {
		public bool Active { get; set; }
	}
	class OperatorFactory {
		public static readonly True True = new True();
	}
	class True : Operator {
		public bool Active { get { return true; } set { } }
	}
	class Not : Operator {
		public Operator Input { get; set; }
		public void Update() {
			Active = !Input.Active;
		}
		public bool Active { get; set; }
	}

	class Motor {
		public int Time;
		public int Cycle = 60 * 4;
		public int Phase;
		public float Minimum;
		public float Maximum = 1;
		public float Output { get; private set; }

		public Motor Clone() {
			var value = new Motor
			{
				Time = this.Time,
				Cycle = this.Cycle,
				Phase = this.Phase,
				Minimum = this.Minimum,
				Maximum = this.Maximum,
			};
			return value;
		}

		public void Update() {
			Time++;
			if (Time >= Cycle) Time = 0;
			Output = (float)Math.Sin((Time + Phase) * (Math.PI * 2.0 / Cycle));
		}

		public float Target {
			get {
				return (Output + 1) * 0.5f * (Maximum - Minimum) + Minimum;
			}
		}
		public float GetOutputVelocity(float current) {
			return Math.Sign(Target - current) * (Maximum - Minimum);
		}
	}

}
