﻿
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework;

namespace XELF.Sphynx {

	/// <summary>
	/// 
	/// </summary>
	class KeyboardInput {
		public KeyboardState Previous;
		public KeyboardState Current;

		public void Update() {
			Previous = Current;
			Current = Keyboard.GetState();
		}

		public bool IsPress(Keys key) { return Current.IsKeyDown(key) && Previous.IsKeyUp(key); }


		public void Clear() {
			Previous = Current = Keyboard.GetState();
		}
	}

	class GamepadInput {
		public GamePadState Previous;
		public GamePadState Current;
		public void Update() {
			Previous = Current;
			Current = GamePad.GetState(PlayerIndex.One);
		}
	}

	/// <summary>
	/// 
	/// </summary>
	class MouseInput {
		MouseState previous;
		MouseState current;

		public bool Handled;

		public Vector2 Location {
			get {
				return new Vector2(current.X, current.Y);
			}
		}

		public MouseInput() {
		}
		public void Update() {
			previous = current;
			Handled = false;

			KeyboardState state = Keyboard.GetState();

			Point translation = Point.Zero;

			if (!state.IsKeyDown(Keys.LeftControl) && !state.IsKeyDown(Keys.RightControl)) {

				if (state.IsKeyDown(Keys.Left)) {
					translation.X--;
				}
				if (state.IsKeyDown(Keys.Right)) {
					translation.X++;
				}
				if (state.IsKeyDown(Keys.Up)) {
					translation.Y--;
				}
				if (state.IsKeyDown(Keys.Down)) {
					translation.Y++;
				}
				if (state.IsKeyDown(Keys.LeftShift) || state.IsKeyDown(Keys.RightShift)) {
					translation.X *= 4;
					translation.Y *= 4;
				}
			}
			IsTranslated = translation.X != 0 || translation.Y != 0;
			if (IsTranslated) {
				current = Mouse.GetState();
				Mouse.SetPosition(current.X + translation.X, current.Y + translation.Y);
			}
			current = Mouse.GetState();
			if (current.X != previous.X || current.Y != previous.Y) {
				IsTranslated = true;
			}
		}
		public bool IsTranslated;
		public MouseState Current { get { return current; } }
		public MouseState Previous { get { return previous; } }
	}

}
