﻿using System;
using System.Collections.Generic;
using System.Text;
using Microsoft.Xna.Framework;

namespace XELF.Sphynx {

	interface ICloneable<T> {
		T Clone();
	}

	static partial class Helper {
		public static float ToRadians(this float degrees) {
			return MathHelper.ToRadians(degrees);
		}
		public static float ToDegrees(this float radians) {
			return MathHelper.ToDegrees(radians);
		}

		public static int NearestEdgeMidIndexOf(this FarseerGames.FarseerPhysics.Collisions.Vertices shape, Vector2 point) {
			float distanceSquared = float.MaxValue;
			int index = -1;
			for (int i = 0; i < shape.Count; i++) {
				Vector2 midPoint = shape.GetEdgeMidPoint(i);
				float d = Vector2.DistanceSquared(midPoint, point);
				if (d < distanceSquared) {
					distanceSquared = d;
					index = i;
				}
			}
			return index;
		}
		public static int NearestIndexOf(this List<Vector2> vertices, Vector2 point, out float distanceSquared) {
			distanceSquared = float.MaxValue;
			int index = -1;
			for (int i = 0; i < vertices.Count; i++) {
				float d = Vector2.DistanceSquared(vertices[i], point);
				if (d < distanceSquared) {
					distanceSquared = d;
					index = i;
				}
			}
			return index;
		}
		public static int NearestIndexOf(this List<Vector2> vertices, Vector2 point) {
			float distanceSquared;
			return NearestIndexOf(vertices, point, out distanceSquared);
		}

		public static List<T> Clone<T>(this List<T> source) {
			return new List<T>(source);
		}

		public static void CloneTo<T>(this List<T> source, List<T> destination)
			where T : ICloneable<T> {
			destination.Clear();
			foreach (T value in source) {
				destination.Add(value.Clone());
			}
		}
		public static void CopyTo<T>(this List<T> source, List<T> destination) {
			if (destination == source)
				return;
			destination.Clear();
			destination.AddRange(source);
		}
		public static void CopyTo<T>(this T[] source, T[] destination) {
			if (destination == source)
				return;
			if (destination.Length != source.Length)
				Array.Resize(ref destination, source.Length);
			source.CopyTo(destination, 0);
		}
	}

	static partial class Helper {
		public static void Clear(this StringBuilder text) {
			text.Remove(0, text.Length);
		}
	}

}
