﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace XELF.Framework {
	namespace Physics {

		public class Joint {
		}

		public class Bodies {
			void Add(Body item) {
			}
		}

		public class World {
			Bodies bodies;
			public Bodies Bodies {
				get { return bodies; }
			}
		}

		public abstract class Body : IDisposable {
			public void Dispose() {
			}
			public object Tag;
		}

	}
	public class Shape {
		public void Dispose() {
		}
	}
}

namespace XELF.Framework {

	public partial class Vector2 {
		public float X, Y;
	}
	public partial class Vector2 {
		public Vector2(float x, float y) {
			X = x; Y = y;
		}
	}
	public partial class Vector2 {
		public static Vector2 operator +(Vector2 a, Vector2 b) {
			return new Vector2(a.X + b.X, a.Y + b.Y);
		}
	}
	public partial class Vector2 {
		public static Vector2 operator -(Vector2 a, Vector2 b) {
			return new Vector2(a.X - b.X, a.Y - b.Y);
		}
	}
	public partial class Vector2 {
		public static Vector2 operator *(Vector2 a, Vector2 b) {
			return new Vector2(a.X * b.X, a.Y * b.Y);
		}
	}
	public partial class Vector2 {
		public static Vector2 operator *(Vector2 a, float scale) {
			return new Vector2(a.X * scale, a.Y * scale);
		}
	}
	public partial class Vector2 {
		public static Vector2 operator /(Vector2 a, float scale) {
			var r = 1.0f / scale;
			return new Vector2(a.X * r, a.Y * r);
		}
	}

	public partial class Vector2 {
		public void Normalize() {
			var r = 1.0f / (float)Math.Sqrt(X * X + Y * Y);
			X *= r;
			Y *= r;
		}
	}

}

