﻿using System;
using XELF.Framework;

partial class MathSample2 {
	static void Main(string[] args) {
		MatrixTranspose();
		MatrixMultiply();
		Transform();
		MatrixTranslation();
		MatrixScale();
		MatrixRotation();
		MatrixFromAxisAngle();
	}
}

partial class MathSample2 {
	static void MatrixTranspose() {
        Console.WriteLine("-- 4.3.1項 139ページ"); 
        Console.WriteLine("転置行列");
		{
			var a = new Matrix(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16);
			Console.WriteLine("Tranpose({0})\n= {1}", a, Matrix.Transpose(a));
            Console.WriteLine();
        }
	}
}

partial class MathSample2 {
	static void MatrixMultiply() {
        Console.WriteLine("-- 4.3.2項 140ページ"); 
		Console.WriteLine("行列の積");
		{
			var a = new Matrix(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16);
			var b = new Matrix(-16, -15, -14, -13, -12, -11, -10, -9, -8, -7, -6, -5, -4, -3, -2, -1);
			Console.WriteLine("{0}\n* {1}\n= {2}", a, b, a * b);
            Console.WriteLine();
        }
	}
}

partial class MathSample2 {
	static void Transform() {
        Console.WriteLine("-- 4.3.3項 144ページ");
        Console.WriteLine("変換");
		{
			var position = new Vector3(1, 2, 3);
			var transform = new Matrix(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16);
			Console.WriteLine("Transform({0},\n {1})\n= {2}",
				position, transform, Vector3.Transform(position, transform));
            Console.WriteLine();
        }
	}
}

partial class MathSample2 {
	static void MatrixTranslation() {
        Console.WriteLine("-- 4.3.6項 149ページ");
        Console.WriteLine("平行移動");
		{
			Matrix transform;
			var position = new Vector3(1, 2, 3);
			var point = new Vector3(1, 1, 1);
			Matrix.CreateTranslation(ref position, out transform);
			Console.WriteLine("position = {0},\ntransform = {1}", position, transform);
			Console.WriteLine("変換前の点 = {0}, 変換後の点 = {1}",
				point, Vector3.Transform(point, transform));
            Console.WriteLine();
        }
	}
}

partial class MathSample2 {
	static void MatrixScale() {
        Console.WriteLine("-- 4.3.7項 150ページ");
        Console.WriteLine("スケーリング");
		{
			Matrix transform;
			var scale = 3.0f;
			var point = new Vector3(1, 1, 1);
			Matrix.CreateScale(scale, out transform);
			Console.WriteLine("scale = {0},\ntransform = {1}", scale, transform);
			Console.WriteLine("変換前の点 = {0}, 変換後の点 = {1}",
				point, Vector3.Transform(point, transform));
            Console.WriteLine();
        }
	}
}

partial class MathSample2 {
	static void MatrixRotation() {
        Console.WriteLine("-- 4.3.8項 154ページ");
        Console.WriteLine("回転");
		{
			var angle = MathHelper.Pi / 3;
			var point = new Vector3(1, 1, 1);
			var transform = Matrix.CreateRotationX(angle);
			Console.WriteLine("角度 = {0} [rad]", angle);
			Console.WriteLine("X軸回転の変換行列 = {0}", transform);
			Console.WriteLine("変換前の点 = {0}, 変換後の点 = {1}",
				point, Vector3.Transform(point, transform));
            Console.WriteLine();
        }
	}
}

partial class MathSample2 {
	static void MatrixFromAxisAngle() {
        Console.WriteLine("-- 4.3.9項 155ページ");
        Console.WriteLine("任意軸回転");
		{
			var axis = new Vector3(1, 2, 3);
			axis.Normalize();
			var angle = MathHelper.Pi / 3;
			var point = new Vector3(1, 1, 1);
			var transform = Matrix.CreateFromAxisAngle(axis, angle);
			Console.WriteLine("軸 = {0}", axis);
			Console.WriteLine("角度 = {0} [rad]", angle);
			Console.WriteLine("変換行列 = {0}", transform);
			Console.WriteLine("変換前の点 = {0}, 変換後の点 = {1}",
				point, Vector3.Transform(point, transform));
            Console.WriteLine();
        }
	}
}
