﻿using System;
using XELF.Framework;

partial class MathSample1 {
	static void Main(string[] args) {
		VectorAddSubtract();
		VectorScalarMultiply();
		VectorLength();
		VectorDot();
		VectorCross();
		VectorNormalize();
		Normal();
		Volume();
	}
}

partial class MathSample1 {
	static void VectorAddSubtract() {
        Console.WriteLine("-- 4.2.1項 117ページ");
		Console.WriteLine("ベクトルの和と差");
		{
			var a = new Vector2(1, 2);
			var b = new Vector2(3, -4);
			Console.WriteLine("{0} + {1} = {2}", a, b, a + b);
		}
		{
			var a = new Vector3(1, 2, 5.6f);
			var b = new Vector3(3, -4, 7.8f);
			Console.WriteLine("{0} + {1} = {2}", a, b, a + b);
		}
		{
			var a = new Vector4(1, 2, 5.6f, 9);
			var b = new Vector4(3, -4, 7.8f, 10);
			Console.WriteLine("{0} + {1} = {2}", a, b, a + b);
            Console.WriteLine();
        }
	}
}

partial class MathSample1 {
	static void VectorScalarMultiply() {
        Console.WriteLine("-- 4.2.2項 120ページ");
        Console.WriteLine("ベクトルのスカラー倍");
		{
			var a = new Vector2(1, 2);
			var b = 3.0f;
			Console.WriteLine("{0} * {1} = {2}", a, b, a * b);
		}
		{
			var a = new Vector3(1, 2, -4.5f);
			var b = 3.0f;
			Console.WriteLine("{0} * {1} = {2}", a, b, a * b);
		}
		{
			var a = new Vector4(1, 2, -4.5f, 6);
			var b = 3.0f;
			Console.WriteLine("{0} * {1} = {2}", a, b, a * b);
		}
        Console.WriteLine();
    }
}

partial class MathSample1 {
	static void VectorLength() {
        Console.WriteLine("-- 4.2.3項 123ページ");
        Console.WriteLine("ベクトルの大きさ");
		{
			var a = new Vector2(1, 2);
			Console.WriteLine("|{0}| = {1}", a, a.Length());
		}
		{
			var a = new Vector3(1, 2, -4.5f);
			Console.WriteLine("|{0}| = {1}", a, a.Length());
		}
		{
			var a = new Vector4(1, 2, -4.5f, 6);
			Console.WriteLine("|{0}| = {1}", a, a.Length());
		}
        Console.WriteLine();
    }
}

partial class MathSample1 {
	static void VectorDot() {
        Console.WriteLine("-- 4.2.4項 127ページ");
        Console.WriteLine("ベクトルの内積");
		{
			var a = new Vector2(1, 2);
			var b = new Vector2(-3, 4.5f);
			Console.WriteLine("Dot({0}, {1}) = {2}", a, b, Vector2.Dot(a, b));
		}
		{
			var a = new Vector3(1, 2, 5.6f);
			var b = new Vector3(3, -4, 7.8f);
			Console.WriteLine("Dot({0}, {1}) = {2}", a, b, Vector3.Dot(a, b));
		}
		{
			var a = new Vector4(1, 2, 5.6f, 9);
			var b = new Vector4(3, -4, 7.8f, 10);
			Console.WriteLine("Dot({0}, {1}) = {2}", a, b, Vector4.Dot(a, b));
		}
        Console.WriteLine();
    }
}

partial class MathSample1 {
	static void VectorCross() {
        Console.WriteLine("-- 4.2.5項 129ページ");
		Console.WriteLine("ベクトルの外積");
		{
			var a = new Vector3(1, 2, 5.6f);
			var b = new Vector3(3, -4, 7.8f);
			Console.WriteLine("Cross({0}, {1}) = {2}", a, b, Vector3.Cross(a, b));
		}
        Console.WriteLine();
    }
}

partial class MathSample1 {
	static void VectorNormalize() {
        Console.WriteLine("-- 4.2.6項 131ページ"); 
        Console.WriteLine("ベクトルの正規化");
		{
			var a = new Vector2(1, 2);
			Console.WriteLine("Normalize({0}) = {1}", a, Vector2.Normalize(a));
		}
		{
			var a = new Vector3(1, 2, 5.6f);
			Console.WriteLine("Normalize({0}) = {1}", a, Vector3.Normalize(a));
		}
		{
			var a = new Vector4(1, 2, 5.6f, 9);
			Console.WriteLine("Normalize({0}) = {1}", a, Vector4.Normalize(a));
		}
        Console.WriteLine();
    }
}

partial class MathSample1 {
	static void Normal() {
        Console.WriteLine("-- 4.2.7項 133ページ"); 
        Console.WriteLine("法線");
		{
			var a = new Vector3(1, 2, 5.6f);
			var b = new Vector3(3, -4, 7.8f);
			var c = new Vector3(5, 6, 7);
			var normal = Vector3.Cross(a - c, b - c);
			normal.Normalize();
			Console.WriteLine("三角形({0}, {1}, {2})の正規化された法線 = {3}",
				a, b, c, normal);
		}
        Console.WriteLine();
    }
}

partial class MathSample1 {
	static void Volume() {
        Console.WriteLine("-- 4.2.8項 135ページ"); 
        Console.WriteLine("体積");
		{
			var a = new Vector3(1, 2, 5.6f);
			var b = new Vector3(3, -4, 7.8f);
			var c = new Vector3(5, 6, 7);
			var d = new Vector3(-2, -1, 0);
			var p = a - d;
			var q = b - d;
			var r = c - d;
			var volume = Vector3.ScalarTripleProduct(ref p, ref q, ref r) / 6;
			Console.WriteLine("四面体({0}, {1}, {2}, {3})の体積 = {4}",
				a, b, c, d, volume);
		}
        Console.WriteLine();
    }
}
