﻿using System.Collections.Generic;
using JigLibX.Physics;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Graphics;

namespace Hair {

	class Ribbon {
		readonly List<PhysicsObject> items = new List<PhysicsObject>();
		readonly List<Constraint> constraints = new List<Constraint>();
		readonly PhysicsSystem system;
		readonly PhysicsObject parent;

		public Ribbon(Game game, PhysicsSystem system, Model capsuleModel,
			PhysicsObject parent, Vector3 point, int segments) {
			this.system = system;
			this.parent = parent;

			items.Add(parent);

			float s = 0.25f;
			float mass = 0.0001f;

			var position = parent.PhysicsBody.Position + point;
			for (int i = 0; i < segments; i++) {
				var item = new CapsuleObject(game, capsuleModel,
					1.5f * s, 2.5f * s, mass, Matrix.Identity, position + new Vector3(0, i * 2.5f * s, 0));
				items.Add(item);
				game.Components.Add(item);
			}

			float allowedDistance = 0.001f;
			float timescale = 0.001f;
			{
				var constraint1 = new ConstraintPoint(
					items[0].PhysicsBody, point + new Vector3(+1, 0, +3) * s,
					items[1].PhysicsBody, new Vector3(+1, 0, -3) * s, allowedDistance, timescale);
				constraints.Add(constraint1);
				constraint1.EnableConstraint();
				var constraint2 = new ConstraintPoint(
					items[0].PhysicsBody, point + new Vector3(-1, 0, +3) * s,
					items[1].PhysicsBody, new Vector3(-1, 0, -3) * s, allowedDistance, timescale);
				constraints.Add(constraint2);
				constraint2.EnableConstraint();
			}
			for (int i = 1; i < segments; i++) {
				var constraint1 = new ConstraintPoint(
					items[i].PhysicsBody, new Vector3(+1, 0, +3) * s,
					items[i + 1].PhysicsBody, new Vector3(+1, 0, -3) * s, allowedDistance, timescale);
				constraints.Add(constraint1);
				constraint1.EnableConstraint();
				var constraint2 = new ConstraintPoint(
					items[i].PhysicsBody, new Vector3(-1, 0, 3) * s,
					items[i + 1].PhysicsBody, new Vector3(-1, 0, -3) * s, allowedDistance, timescale);
				constraints.Add(constraint2);
				constraint2.EnableConstraint();
			}
			for (int i = 0; i < segments; i++) {
				HairGame.DisableCollisions(items[i].PhysicsBody, items[i + 1].PhysicsBody);
			}
		}
	}

}
