﻿using JigLibX.Collision;
using JigLibX.Geometry;
using JigLibX.Math;
using JigLibX.Physics;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Graphics;

namespace Hair {

	/// <summary>
	/// カプセル形状の物体
	/// </summary>
	public class CapsuleObject : PhysicsObject {
		public CapsuleObject(Game game, Model model, float radius, float length, float mass,
			Matrix orientation, Vector3 position)
			: base(game, model) {
			body = new Body();
			collision = new CollisionSkin(body);
			collision.AddPrimitive(
				new Capsule(Vector3.Transform(new Vector3(-0.5f, 0, 0), orientation), orientation, radius, length),
				new MaterialProperties(1.0f, 0.5f, 0.5f));
			#region 古いバージョン用
			//collision.AddPrimitive(
			//	new Capsule(Vector3.Transform(new Vector3(-0.5f, 0, 0), orientation), orientation, radius, length),
			//	(int)MaterialTable.MaterialID.UserDefined, new MaterialProperties(1.0f, 0.5f, 0.5f));
			#endregion
			body.CollisionSkin = this.collision;
			Vector3 com = SetMass(mass);
			body.MoveTo(position + com, Matrix.Identity);

			collision.ApplyLocalTransform(new Transform(-com, Matrix.Identity));

			body.EnableBody();
			this.scale = new Vector3(radius, radius, length / 2);

			color = new Vector3(0.2f, 0.2f, 0.1f);
		}

		public override void ApplyEffects(BasicEffect effect) {
			effect.DiffuseColor = color;
		}

	}

}
