﻿using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Graphics;

namespace XELF.PhysX.ClothSample {

	class Visual {
		public Model Model;
		public Mesh Mesh;

		public Matrix World;
		public Matrix View;
		public Matrix Projection;

		public void SetModelTransform() {
			foreach (ModelMesh modelMesh in Model.Meshes) {
				foreach (BasicEffect effect in modelMesh.Effects) {
					effect.World = World;
					effect.View = View;
					effect.Projection = Projection;
				}
			}
		}

		/// <summary>
		/// モデルを指定のMesh（頂点とインデックス）で描画する。
		/// </summary>
		/// <param name="model"></param>
		/// <param name="mesh"></param>
		public static void DrawMesh(Model model, Mesh mesh) {
			foreach (ModelMesh modelMesh in model.Meshes) {
				foreach (var part in modelMesh.MeshParts) {
					part.Effect.Begin();
					foreach (var pass in part.Effect.CurrentTechnique.Passes) {
						pass.Begin();
						part.Effect.GraphicsDevice.VertexDeclaration = part.VertexDeclaration;

						// インデックスをパートわけしない形式での描画
						part.Effect.GraphicsDevice.DrawUserIndexedPrimitives(PrimitiveType.TriangleList,
							mesh.Vertices, 0, mesh.Vertices.Length, mesh.Indices, part.StartIndex,
							part.PrimitiveCount);
						/*
						// ModelMesh本来の形式
						GraphicsDevice.DrawUserIndexedPrimitives(PrimitiveType.TriangleList,
							mesh.Points, part.BaseVertex, part.NumVertices, mesh.Indices, part.StartIndex,
							part.PrimitiveCount);
						*/
						pass.End();
					}
					part.Effect.End();
				}
			}
		}

		/// <summary>
		/// Meshの頂点・インデックスでモデルを描画する。
		/// </summary>
		public void Draw() {
			SetModelTransform();
			DrawMesh(Model, Mesh);
		}
		/// <summary>
		/// モデルの元のメッシュで描画する。
		/// </summary>
		public void DrawModel() {
			SetModelTransform();
			Model.Meshes[0].Draw();
		}
	}

}
