﻿using eyecm.PhysX;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Graphics;
using XELF.Sphynx;

namespace XELF.PhysX {

	/// <summary>
	/// PhysXのデバッグ描画データを描画する。
	/// この機能は、Physics.Parametersの設定と、Shape.FlagsのShapeFlags.Visualizationで有効になる。
	/// </summary>
	class DebugRenderer : DrawableGameComponent {
		readonly VectorGraphics graphics;
		readonly Scene scene;

		public DebugRenderer(Game game, VectorGraphics vectorGraphics, Scene scene)
			: base(game) {
			this.graphics = vectorGraphics;
			this.scene = scene;
		}

		public static Color ColorFrom(DebugRenderable.DebugColor value) {
			return new Color(
				(byte)(value.bgra >> 16),
				(byte)(value.bgra >> 8),
				(byte)(value.bgra),
				(byte)(value.bgra >> 24));
		}
		public static Vector3 Vector3From(DebugRenderable.DebugPosition value) {
			return new Vector3(value.x, value.y, value.z);
		}

		public override void Draw(GameTime gameTime) {
			graphics.Begin();

			// 毎回取得しなければならない
			using (DebugRenderable renderable = scene.GetDebugRenderable()) {

				//foreach (var triangle in renderable.Triangles) { }

				foreach (var line in renderable.Lines) {
					var color = ColorFrom(line.color);
					Vector3 p0 = Vector3From(line.p0);
					Vector3 p1 = Vector3From(line.p1);
					graphics.DrawLine(ref p0, color, ref p1, color);
				}

				//foreach (var point in renderable.Points) { }
			}

			graphics.End();

			base.Draw(gameTime);
		}
	}

}
