﻿using Microsoft.Xna.Framework;

namespace XELF.PhysX.ClothSample {

	/// <summary>
	/// 物理計算の入出力に使うポリゴンメッシュ
	/// </summary>
	class Mesh {
		public Vector3[] Points;
		public int[] Indices;

		/// <summary>
		/// 格子状のメッシュを作る。
		/// </summary>
		/// <param name="width"></param>
		/// <param name="height"></param>
		/// <returns></returns>
		public static Mesh CreateGrid(int width, int height) {
			var mesh = new Mesh();

			mesh.Points = new Vector3[(width + 1) * (height + 1)];
			mesh.Indices = new int[width * height * 6];
			{
				int stride = width + 1;
				{
					int v = 0;
					for (int y = 0; y < height + 1; y++) {
						for (int x = 0; x < stride; x++) {
							mesh.Points[v++] = new Vector3(x, y, 0);
						}
					}
				}
				{
					int i = 0;
					for (int y = 0; y < height; y++) {
						for (int x = 0; x < width; x++) {
							int j = x + y * stride;
							mesh.Indices[i] = j;
							mesh.Indices[i + 1] = j + 1;
							mesh.Indices[i + 2] = j + stride;
							mesh.Indices[i + 3] = j + 1;
							mesh.Indices[i + 4] = j + stride + 1;
							mesh.Indices[i + 5] = j + stride;
							i += 6;
						}
					}
				}
			}
			return mesh;
		}
	}

}
