$(function() {
	// 連携キット、local時はexit
	if ($.LiVE.bdkit && location.protocol=="file:") return;
	
	var $article = $.LiVE.Elements.PANELS.article.find("> .default");
	$article.each(function() {
		var $this = $(this),
			id = $this.parent().attr("id").match(/[0-9]+/),
			$cont = $("#" + id + "-contents"),
			$tilelist = $this.find(".tilelist"),
			$list = $tilelist.find("li"),
			$tile = $this.find(".tile"),
			$cts = $this.find(".cts"),
			$block = $this.find('div.block'),
			$hdr = $this.find('header.plate');
		
		$tile.eq(0).css({ display: "block" }).animate({ opacity: 1 }, "slow");
		$list.eq(0).addClass("on");
		
		if ($list.length>1) {
			$list.each(function(i) {
				if ( !$(this).html() ) {
					$(this).hide();
				}
				$(this).click(function() {
					$list.removeClass("on");
					$(this).addClass("on");
					$tile.stop().animate({
						opacity: 0
					},{
						duration:"fast",
						complete: function() {
							$tile.css({ display: "none" });
							$tile.eq(i).css({ display: "block" }).stop().animate({ opacity: 1 }, "slow", resize);
						}
					});
				});
			});
		}
		
		$(window).bind($.LiVE.RESIZE_EVENT, resize);
		
		function resize() {
			var h = $.LiVE.getTileHeight('id' + id);
			var pos = $cont.position();
			var btm = ($.LiVE.mobile.check) ? 20:$.LiVE.util.getNumber($block.css("padding-bottom"));
			
			if ($.LiVE.body.scroll=="vertical" && $.LiVE.mobile.check) {
				var listH = $tilelist.height() + pos.top;
				if (listH > h ) h = listH;
				
				// 記事部分の高さ計算
				var contH = 0;
				// listをクリックしたときのみDIVが入る
				if (this.tagName && this.tagName == "DIV") {
					contH = $(this).outerHeight(true) + pos.top;
				} else {
					// クリックで無ければ、最初の要素
					contH = $tile.eq(0).outerHeight(true) + pos.top;
				}
				if (contH > h) h = contH;
				
				$block.height(h + btm);
				$this.height(h + btm);
				
			} else {
				// スライドタイトル、本文分減らす
				h -= $hdr.outerHeight(true);
				
				$tilelist.height(h - btm);
				$cts.height(h - btm);
			}
		}
		
		resize();
	});
});