$(function() {
	// 連携キット、local時はexit
	if ($.LiVE.bdkit && location.protocol=="file:") return;
	
	var $album = $("> .default", $.LiVE.Elements.PANELS.album);
	$album.each(function() {
		var $this = $(this),
			$imgs = $this.find("a[data-group]"),
			$tiles = $this.find(".tile"),
			_maxheight = 0;
		
		// オプション
		var option = {};
		// pc
		if ($.LiVE.mobile.check == false) {
			option = {
				titlePosition: 'over',
				padding: 0
			};
		// mobile
		} else {
			option = {
				titlePosition: ($.LiVE.body.scroll=='vertical') ? 'outside':'over',
				transitionIn: 'none',
				transitionOut: 'none',
				overlayColor : '#000',
				changeSpeed: 0,
				speedIn : 0,
				speedOut : 0,
				padding: 0
			};
		}
		
		// common
		option['titleFormat'] = function(title, ary, idx, opts) {
			var text,desc = $(".pic-desc", ary[idx].parentNode.parentNode).text();
			if (title.length > 0) {
				text = '<span id="fancybox-title-over"><strong>' + title + '</strong></span>';
			}
			if (desc.length > 0) {
				if ( text ) {
					desc = '<br/>' + desc;
					text = text.substr(0,text.length - 7);
					text += desc;
				} else {
					text = '<span id="fancybox-title-over">' + desc + '</span>'
				}
			}
			return text;
		};
		
		// call
		$imgs.fancybox(option);
		
		function _flatheight(_tiles) {
			_tiles.each(function() {
				var _height = $(this).height();
				_maxheight = _height > _maxheight ? _height : _maxheight;
			});
			_tiles.height(_maxheight);
		}
		
		$(window).load(function() {	//Chrome対策：load後に実height取得可能
			_flatheight($this.find(".tile"));
		});
	});
});