$(function() {
	// 連携キット、local時はexit
	if ($.LiVE.bdkit && location.protocol=="file:") return;
	
	var $panels = $.LiVE.Elements.PANELS.all;
	
	//パネルセット関数
	$.LiVE.panelstyle.settings = { width: "100%", height: "100%"};
	$.LiVE.panelstyle.func = function(panel,i) {	//横100％ずつパネル位置設定
		panel.attr("data-order",i).css("left", i*100+"%");
	};
	$.LiVE.panelstyle.set();
	
	var $window = $(window),
		$body = $("body"),
		$main = $("#main"),
		$contents = $("#contents");
	
	if ($.LiVE.mobile.check) {
		var ua = navigator.userAgent;
		if (ua.indexOf('Android 4.0')>-1 || ua.indexOf('Android 3.2')>-1) {
		} else {
			$contents.css({"overflow-x": "hidden", "overflow-y": "auto"});
		}
	}
	
	//ナビ
	$.LiVE.navi = {
		duration: "slow",
		easing: "easeOutExpo",
		jump: function(id) {
			var i = $.LiVE.getPanelIndex(id);
			pageScroll($contents.width() * i);
			
			$.LiVE.currentpanelorder = i;
			if ($.LiVE.bdkit==false) location.hash = id;
			$.LiVE.navicontrol.feedback(id);
		},
		prev: function() {
			var fblay = $('#fancybox-overlay');
			if ( fblay.length == 0 || fblay.css('display') == "none" ) {
				var i = $.LiVE.currentpanelorder;
				
				if (i>0) {
					i -= 1;
					pageScroll($contents.width() * (i));
					
					$.LiVE.currentpanelorder = i;
					
					var id = $panels.eq(i).attr("id");
					if ($.LiVE.bdkit==false) location.hash = id;
					$.LiVE.navicontrol.feedback(id);
				}
			}
		},
		next: function() {
			var fblay = $('#fancybox-overlay');
			if ( fblay.length == 0 || fblay.css('display') == "none" ) {
				var i = $.LiVE.currentpanelorder,
					_end = true;
				
				if (i < $panels.length-1) i += 1;
				
				pageScroll($contents.width() * (i));
				
				$.LiVE.currentpanelorder = i;
				_end = false;
				
				var id = $panels.eq(i).attr("id");
				if ($.LiVE.bdkit==false) location.hash = id;
				$.LiVE.navicontrol.feedback(id);
				return _end;
			}
		},
		pagetop: function() {
			pageScroll(0);
			
			$.LiVE.currentpanelorder = 0;
			
			var id = $panels.eq(0).attr("id");
			if ($.LiVE.bdkit==false) location.hash = id;
			$.LiVE.navicontrol.feedback(id);
		}
	};
	
	function pageScroll(targetScrollLeft) {
		var fblay = $('#fancybox-overlay');
		if ( fblay.length == 0 || fblay.css('display') == "none" ) {
			$contents.stop().animate({
					scrollLeft: targetScrollLeft
				},{
					duration: "slow",
					easing: "easeOutExpo",
					step: ($.LiVE.mobile.check) ? null:animateScroll,
					complete: ($.LiVE.mobile.check) ? null:animateScroll
				}
			);
		}
	}
	
	// Parallax
	function animateScroll() {
		// currentPanelと前後1つまでが対象
		var crnt = $.LiVE.currentpanelorder;
		var st = (crnt<=0) ? 0:crnt-1;
		var ed = (crnt<$panels.length-1) ? crnt + 1:$panels.length-1;
		
		var pos = this.scrollLeft;
		var w = $contents.width();
		
		// each panel
		for (var i=st; i<=ed; i++) {
			var panel = $($panels.get(i));
			var conf = $.LiVE.panel[panel[0].id];
			
			if (conf.data.bganimation) {
				var target = w * i;
				var diff = target - pos;
				
				var bg = conf.bg.thunder;
				var pbg = conf.bg.wind;
				
				if (bg[1].length > 0 && bg[8] == false) {
					// calc offset
					var offset = 0;
					
					var tileImgW = bg[6];
					offset = (bg[3]=='left') ? 0:
									(bg[3]=='center') ? (w - tileImgW) / 2:
									w - tileImgW;	// right
					
					// animate
					var bx = panel.find(".box:has(.block)");
					bx.css('backgroundAttachment', 'fixed');
					bx.css('backgroundPosition',  (offset - diff * 0.8 * -1) + 'px ' + bg[4]);
				}
				
				if (pbg[1].length > 0 && pbg[8] == false) {
					// calc offset
					var poffset = 0;
					
					var panelImgW = pbg[6];
					poffset = (pbg[3]=='left') ? 0:
									(pbg[3]=='center') ? (w - panelImgW) / 2:
									w - panelImgW;	// right
					
					panel.css('backgroundAttachment', 'fixed');
					panel.css('backgroundPosition', (poffset - diff * 0.35 * -1) + 'px ' + bg[4]);
				}
				
			}
			
		}
	}
	
	/********
	キーボード
	********/
	if ($.LiVE.mode.name!="edit") {
		$body
			.bind($.LiVE.Events.KEY_RIGHT, $.LiVE.navi.next)
			.bind($.LiVE.Events.KEY_LEFT, $.LiVE.navi.prev);
		
		// key sound
		$body
			.bind($.LiVE.Events.KEY_RIGHT, function() {
				if ($.LiVE.sesound) $.LiVE.sesound.click();
			})
			.bind($.LiVE.Events.KEY_LEFT, function() {
				if ($.LiVE.sesound) $.LiVE.sesound.click();
			});
	}
	
	/********
	リサイズ関数上書き
	********/
	$.LiVE.panelresizeset = function() {
		$.LiVE.navi.jump($panels.eq($.LiVE.currentpanelorder).attr("id"));
	};
});