$(function() {
	// 連携キット、local時はexit
	if ($.LiVE.bdkit && location.protocol=="file:") return;
	
	var $calendar = $("> .default", $.LiVE.Elements.PANELS.calendar);
	
	$calendar.each(function(){
		var pref = $.LiVE.panel[this.parentNode.id],
			$block = $(this).find(".block"),
			$board = $(this).find(".board");
		
			if ( pref.data ) {
				for ( keys in pref.data ) {
					switch(keys) {
						case "width":
							var calW = pref.data[keys];
							$board.css("width",calW);
						break;
						case "height":
							var calH = pref.data[keys];
							$board.css("height",calH);
						break;
					}
					
				}
			}
		
		// loading
		var loading = $('<div class="cal-loading">');
		loading.appendTo(this.parentNode);
		var spinner = new Spinner({
			lines: 14,
			length: 4,
			width: 4,
			radius: 11,
			color: '#fff',
			speed: 1,
			trail: 60,
			hwaccel: true,
			top: 'auto',
			left: 'auto'
			}).spin(loading[0]);
		
		// dialog
		var dlg = $('<div class="cal-dialog">');
		dlg.append($('<a href="javascript:;" class="cal-desc">詳細</a>'));
		dlg.append($('<a href="javascript:;" class="cal-import">自分のカレンダーに追加</a>'));
		dlg.append($('</div>'));
		dlg.appendTo(this.parentNode);
		
		// for hide dialog
		var hideDialog = function() {
			var tm = setTimeout(function(){
				dlg.hide();
			}, 1500);
			
			$.data(dlg[0], 'tm', tm);
		};
		
		// for cancel 'hide dialog'
		var cancelHideDialog = function() {
			var tm = $.data(dlg[0], 'tm');
			if (typeof(tm) != 'undefined') clearTimeout(tm);
		};
		
		dlg.mouseover(cancelHideDialog).mouseout(hideDialog);
		
		// add all calendar
		$(".import-all-cal a", this).click(function(){
			window.open('http://www.google.com/calendar/render?cid=' + encodeURIComponent(pref.data.url));
			return false;
		});
		
		// render calendar
		var $this = $(this);
		var tile = $(".tile", this);
		tile.fullCalendar({
			header: {
				left: 'prev,next today',
				center: 'title',
				right: 'month, agendaWeek, agendaDay'
			},
			events: pref.data.url,
			eventClick: function(event, je, view) {
				return false;
			},
			eventMouseover: function(event, je, view) {
				cancelHideDialog();
				
				var diff = $(window).scrollTop() - $this.parent().offset().top;
				dlg.css({
					top: je.clientY + diff + 10,
					left: je.clientX - 140
				});
				
				var ancs = $('a', dlg).unbind();
				ancs.filter('.cal-desc').click(function(){
					window.open(event.url, 'gcalevent', 'width=700,height=600');
				});
				ancs.filter('.cal-import').click(function(){
					var eventUrl = 'http://www.google.com/calendar/event?action=TEMPLATE'
						+ '&text=' + event.title + '&details=' + event.description + '&location=' + event.location;
					
					// dates
					var dates = '';
					if (event.allDay) {
						var st = $.fullCalendar.formatDate(event.start, "yyyyMMdd");
						dates = st + '/' + st;
					} else {
						var st = $.fullCalendar.formatDate(event.start, "yyyyMMdd'T'HHmmss");
						var ed = $.fullCalendar.formatDate(event.end, "yyyyMMdd'T'HHmmss");
						dates = st + '/' + ed;
					}
					
					eventUrl += '&dates=' + dates;
					
					window.open(eventUrl);
				});
				
				dlg.show();
			},
			eventMouseout: function(event, je, view) {
				hideDialog();
			},
			loading: function(isLoading) {
				if (isLoading) {
					loading.show();
				} else {
					loading.hide();
				}
			},
			/*
			// 日本語表記にする場合にはコメントアウトしてください。
			monthNames: ['1月', '2月', '3月', '4月', '5月', '6月', '7月', '8月', '9月', '10月', '11月', '12月'],
			monthNamesShort: ['1月', '2月', '3月', '4月', '5月', '6月', '7月', '8月', '9月', '10月', '11月', '12月'],
			dayNames: ['日曜日', '月曜日', '火曜日', '水曜日', '木曜日', '金曜日', '土曜日'],
			dayNamesShort: ['日', '月', '火', '水', '木', '金', '土'],
			buttonText: { today: '今日', month: '月', week: '週', day: '日' },
			titleFormat: {
				month: "yyyy年 MMMM",
				week: "yyyy年 MMM d日{ '&#8212;'[ yyyy年][ MMM] d日}",
				day: "yyyy年 MMM d日 '('dddd')'"
			},
			columnFormat: { month: "ddd", week: "M/d '('ddd')'", day: "M/d (dddd)"},
			*/
			timeFormat: 'H:mm'
		});
	});
});