$(function() {
	// 連携キット、local時はexit
	if ($.LiVE.bdkit && location.protocol=="file:") return;
	
	var $balloon = $.LiVE.Elements.WIDGETS.balloon.find(".default");
	$balloon.each(function() {
		
		var $this = $(this).parent(),
			id = $this.attr("id"),
			$wrap = $("#balloon-" + id),
			$img = $this.find("img"),
			conf = $.LiVE.widget[id],
			size = {
				width: $img.width(),
				height: $img.height()
			},
			$a = $this.find("a").width(size.width).height(size.height),
			interval = 0,
			sw = true;
		
		// サイズ調整
		if (typeof(conf.css.width)=='undefined' || conf.css.width.length == 0) $this.width(size.width);
		if (typeof(conf.css.height)=='undefined' || conf.css.height.length == 0) $this.height(size.height);
		
		// mobile
		if ($.LiVE.mobile.check) {
			conf.data.effect = 0;
			conf.data.img = '';
		}
		
		// ロールオーバー画像
		if (conf.data.img) {
			var $overimg = $img.clone().addClass("overimg").attr("src",  conf.data.img).appendTo($a).hide();
			
			// エフェクト
			switch(conf.data.effect.toString()) {
			// なし、ランブル
			case "0":
			case "3":
				$a.hover(function(){
					$overimg.show();
					$img.hide();
				}, function(){
					$img.show();
					$overimg.hide();
				});
				
				break;
				
			// トランジション
			case "1":
				$wrap.addClass("crossfade");
				
				switch (conf.data.event) {
				case 0:
					$overimg.show();
					$overimg.css('opacity',0);
					$a.hover(function(){
						$img.animate({opacity: 0}, {duration: 600, queue: false});
						$overimg.animate({opacity: 1}, {duration: 600, queue: false});
					}, function(){
						$img.animate({opacity: 1}, {duration: 600, queue: false});
						$overimg.animate({opacity: 0}, {duration: 600, queue: false});
					});
					break;
				case 1:
					interval = 1400; break;
				case 2:
					interval = 6000; break;
				case 3:
					interval = 15000; break;
				}
				
				// Timer
				if (interval > 0) {
					function doTimerCross() {
						if (sw) {
							$img.stop().fadeOut("slow");
							$overimg.stop().fadeIn("slow");
						} else {
							$overimg.stop().fadeOut("slow");
							$img.stop().fadeIn("slow");
						}
						sw = !sw;
					}
					doTimerCross();
					setInterval(doTimerCross, interval);
				}
				
				break;
				
			}
		}
		
		// ズームエフェクト
		if (conf.data.effect.toString()=="2") {
			$wrap.addClass("zoom");
			
			function doZoom(elm, speed) {
				elm.stop().show().animate({
					width: size.width * 1.1,
					height: size.height * 1.1,
					marginTop: (size.height * 1.1 - size.height)/2 * -1,
					marginLeft: (size.width * 1.1 - size.width)/2 * - 1
				}, speed);
			}
			
			function unZoom(elm, speed, eraseOnEnd) {
				elm.stop().animate({
					width: size.width,
					height: size.height,
					marginTop: 0,
					marginLeft: 0
				},{
					duration: speed,
					complete: function() {
						if (eraseOnEnd) $(this).hide();
					}
				});
			}
			
			switch (conf.data.event) {
			case 0:
				$a.hover(function(){
					if (conf.data.img) {
						doZoom($overimg, "fast");
					} else {
						doZoom($img, "fast");
					}
				}, function(){
					if (conf.data.img) {
						unZoom($overimg, "fast", true);
					} else {
						unZoom($img, "fast");
					}
				});
				break;
			case 1:
				interval = 1400; break;
			case 2:
				interval = 6000; break;
			case 3:
				interval = 15000; break;
			}
			
			// Timer
			if (interval > 0) {
				function doTimerZoom() {
					if (sw) {
						if (conf.data.img) {
							doZoom($overimg, "slow");
						} else {
							doZoom($img, "slow");
						}
					} else {
						if (conf.data.img) {
							unZoom($overimg, "slow", true);
						} else {
							unZoom($img, "slow");
						}
					}
					sw = !sw;
				}
				doTimerZoom();
				setInterval(doTimerZoom, interval);
			}
			
		// ランブルエフェクト
		} else if (conf.data.effect.toString()=="3") {
			$wrap.addClass("rumble");
			$wrap.jrumble();
			
			switch (conf.data.event) {
			case 0:
				$a.hover(function(){
					$wrap.trigger("startRumble");
				}, function(){
					$wrap.trigger("stopRumble");
				});
				break;
			case 1:
				$wrap.trigger("startRumble");
				break;
			case 2:
				interval = 6000; break;
			case 3:
				interval = 15000; break;
			}
			
			// Timer
			if (interval > 0) {
				function doTimerRumble() {
					if (sw) $wrap.trigger("startRumble");
					else $wrap.trigger("stopRumble");
					sw = !sw;
				}
				doTimerRumble();
				setInterval(doTimerRumble, interval);
			}
			
		}
	});
});