$(function() {
	// 連携キット、local時はexit
	if ($.LiVE.bdkit && location.protocol=="file:") return;
	
	var $slide = $.LiVE.Elements.PANELS.slide.find(".half");
	$slide.each(function() {
		var $this = $(this),
			$tile = $this.find(".tile"),
			id = $this.find(".board").attr("id").match(/id[0-9]+/),
			data = $.LiVE.panel[id].data,
			_effect = "fade",
			_numbers = false,
			_dot = false,
			_thumbs = false,
			_preview = false,
			_bottommargin = 80;
		
		if ($tile.find("li").length==0) return;	//画像が無い場合は処理終了
		
		// ウィンドウのリサイズの時のためにHTMLを待避
		var html = $tile[0].innerHTML;
		// mobile時は軽い画像に置換
		if ($.LiVE.mobile.check && $.LiVE.mobile.type != 'ipad') {
			html = html.replace(/_2.jpg/g, "_4.jpg");
			html = html.replace(/_2.png/g, "_4.png");
			html = html.replace(/width=\"900\"/g, "width=\"800\"");
			html = html.replace(/height=\"1000\"/g, "height=\"889\"");
		}
		$.data($tile[0], "original", html);
		
		if ($.LiVE.mobile.check) _effect = "fade";
		else {
			switch(data.effect) {
				case 0: _effect = "fade"; break;
				case 1: _effect = "fadeFour"; break;
				/*
				case 2: _effect = "showBars"; break;
				case 3: _effect = "cubeShow"; break;
				case 4: _effect = "random"; break;
				*/
				case 2: _effect = "fade"; break;
				case 3: _effect = "fade"; break;
				case 4: _effect = "fade"; break;
			}
		}
		
		switch(data.navigation) {
			case 0: _dot = true; break;
			case 1: _numbers = true; break;
			case 2: _thumbs = true; break;
			case 3: _dot = true; _preview = true; break;
		}
		
		function buildSkitter() {
			var $skitter_base = $this.find(".box_skitter_large");
			var skitter_id = $skitter_base.data("skitter_number");
			
			$tile[0].innerHTML = $.data($tile[0], "original");
			$skitter_base = $this.find(".box_skitter_large");	// reconnect
			
			// 大きさ決定
			var blk = $this.find(".block");
			// まず、幅基準で計算
			var blkWidth = blk.width() * 0.5;
			var blkHeight = _thumbs ? blk.height() - 50 : blk.height();
			if (data.fitTileSize) {
				var imgs = $tile.find("img");
				if (imgs.length > 0) {
					var img = $(imgs[0]);
					var ratio = blkWidth / img.attr("width");
					blkHeight = Math.round(img.attr("height") * ratio);
					if (_thumbs) blkHeight -= 50;
					
					// ブロックの高さを越えていたら再計算
					if (blkHeight > blk.height()) {
						blkHeight = _thumbs ? blk.height() - 50 : blk.height();
						ratio = blkHeight / img.attr("height");
						blkWidth = Math.round(img.attr("width") * ratio);
					}
				}
			}
			
			$skitter_base
			.width(blkWidth)	// half
			.height(blkHeight)
			.skitter({
				fit: (data.fitTileSize == false),
				fit_width: blkWidth,
				fit_height: blkHeight,
				
				auto_play: data.autoplay,
				label: data.label,
				
				animation: _effect,
				
				dots: _dot,
				preview: _preview,
				numbers: _numbers,
				numbers_align: "center",
				thumbs: _thumbs,
				thumbs_align: "left",
				
				navigation: data.arrowbutton,
				progressbar: ($.LiVE.mobile.check || $.LiVE.browser.name=="ie9") ? false:data.arrowbutton,
				
	 			progressbar_css: { 
					top:0,
					left:0,
					height:3,
					borderRadius:0,
					width:blkWidth,
					backgroundColor:'#000',
					opacity:.8
				},
				
				animateNumberOut: { backgroundColor:'#000', color:'#FFF' },
				animateNumberOver: { backgroundColor:'#333', color:'#FFF' },
				animateNumberActive: { backgroundColor:'#FFF', color:'#000' },
				stop_over: false,
				interval:6000
			});
			
			var _bottom = $this.find(".container_thumbs").height() + _bottommargin;
			var $prevBtn = $this.find(".prev_button");
			var $nextBtn = $this.find(".next_button");
			$prevBtn.css({ bottom: _bottom });
			$nextBtn.css({ bottom: _bottom });
			$this.find(".box_skitter > .info_slide").css({ bottom: _bottom });
			$this.find(".info_slide_dots").css({ bottom: _bottom });
			
			if ($.LiVE.mobile.check) {
				$prevBtn.doubleSize();
				$nextBtn.doubleSize();
				$prevBtn.css("right", "140px");
			}
			
			// delete old skitter
			if (typeof(skitter_id) != 'undefined') {
				$skitter_base.skitter_destroy(skitter_id);
			}
		}
		
		var tm = 0;
		var eventName = "resize";
		if ($.LiVE.mobile.check) {
			eventName = "orientationchange";
		}
		$(window).bind(eventName, function(){
			if (tm>0) clearInterval(tm);
			tm = setInterval(function(){
				clearInterval(tm);
				buildSkitter();
			}, 200);
		});
		
	});
});