$(function() {
	// 連携キット、local時はexit
	if ($.LiVE.bdkit && location.protocol=="file:") return;
	
	var $album = $.LiVE.Elements.PANELS.album.find(".scroll"),
		$window = $.LiVE.Elements.WINDOW;
	$album.each(function() {
		var $this = $(this),
			$board = $this.find(".board"),
			$imgs = $board.find("img"),
			$anchors = $this.find("a[data-group]"),
			$tiles = $this.find(".tile"),
			$panel = $this.parent(),
			_id = $panel.attr("id");
		
		$(".board", $this).appendTo($this);
		
		if ($tiles.length==0) return;
		else
			$tiles.css({top: getBottomPos() + 'px'});
		
		// オプション
		var option = {};
		// pc
		if ($.LiVE.mobile.check == false) {
			option = {
				titlePosition: 'over',
				padding: 0
			};
		// mobile
		} else {
			option = {
				titlePosition: ($.LiVE.body.scroll=='vertical') ? 'outside':'over',
				transitionIn: 'none',
				transitionOut: 'none',
				overlayColor : '#000',
				changeSpeed: 0,
				speedIn : 0,
				speedOut : 0,
				padding: 0
			};
		}
		
		// common
		option['titleFormat'] = function(title, ary, idx, opts) {
			var text,desc = $(".pic-desc", ary[idx].parentNode.parentNode).text();
			if (title.length > 0) {
				text = '<span id="fancybox-title-over"><strong>' + title + '</strong></span>';
			}
			if (desc.length > 0) {
				if ( text ) {
					desc = '<br/>' + desc;
					text = text.substr(0,text.length - 7);
					text += desc;
				} else {
					text = '<span id="fancybox-title-over">' + desc + '</span>'
				}
			}
			return text;
		};
		
		// call
		$anchors.fancybox(option);
		
		var $prev = $("#"+_id+"-prev"),
			$next = $("#"+_id+"-next"),
			_totalNum = $imgs.length,
			curPos = 0,
			sw = 0;
		
		function _button() {
			if (_totalNum == 1) {
				$next.hide();
				$prev.hide();
				return;
			}
			
			if (curPos == _totalNum) $next.css({ opacity: 0.4 });
			else $next.css({ opacity: 1 });
			
			if (curPos == 1) $prev.css({ opacity: 0.4 });
			else $prev.css({ opacity: 1 });
		}
		
		function nextImage() {
			var deg = (sw ==0) ? 6: (sw==1) ? 4:-6;
			if (sw==2) sw = 0; else sw++;
			var target = getDispPos();
			$($tiles[curPos]).stop().animate({
				top: target
			}, {
				duration: 1200,
				easing: "easeOutExpo",
				step: function(s) {
					var targetDeg = deg * (target / s);
					var s = "rotate(" + targetDeg + "deg)";
					$(this).css({
						"-webkit-transform": s,
						"-moz-transform": s,
						"-ms-transform": s,
						"transform": s
					});
					
					// for update safari
					var tp = $(this).css("top");
				},
				complete: function() {
					$(this).addClass("in-disp");
				}
			});
			
			if (curPos > 1) {
				$($tiles[curPos - 2]).stop().animate({
					top: -400
				}, {
					duration: 400,
					easing: "easeOutQuint",
					complete: function() {
						$(this).removeClass("in-disp");
					}
				});
			}
			
			curPos++;
		}
		
		function prevImage() {
			curPos--;
			
			var deg = 1;
			var target = getBottomPos();
			$($tiles[curPos]).stop().animate({
				top: target
			}, {
				duration: 400,
				easing: "easeOutExpo",
				step: function(s) {
					var targetDeg = deg * (target / s);
					var s = "rotate(" + targetDeg + "deg)";
					$(this).css({
						"-webkit-transform": s,
						"-moz-transform": s,
						"-ms-transform": s,
						"transform": s
					});
					
					// for update safari
					var tp = $(this).css("top");
				},
				complete: function() {
					$(this).removeClass("in-disp");
				}
			});
			
			if (curPos - 2 > -1) {
				$($tiles[curPos - 2]).stop().animate({
					top: getDispPos()
				}, {
					duration: 1200,
					easing: "easeOutQuint",
					complete: function() {
						$(this).addClass("in-disp");
					}
				});
			}
			
		}
		
		function getDispPos() {
			return parseInt(($panel.height() - 330) / 2);
		}
		
		function getBottomPos() {
			return $panel.height() + 50;
		}
		
		$next.click(function() {
			if (curPos == _totalNum) return;
			nextImage();
			_button();
		});
		
		$prev.click(function() {
			if (curPos <= 1) return;
			prevImage();
			_button();
		});
		
		nextImage();
		_button();
		
		var eventName = "resize";
		if ($.LiVE.mobile.check) {
			eventName = "orientationchange";
		}
		$window.bind(eventName, function() {
			var dispPos = getDispPos();
			var btmPos = getBottomPos();
			
			$tiles.each(function() {
				var tile = $(this);
				if (tile.queue("fx").length == 0) {
					var top = tile.css("top");
					if (top < 0) {
					} else if (tile.hasClass("in-disp")) {
						tile.css("top", dispPos);
					} else {
						tile.css("top", btmPos);
					}
				}
			});
			
			var bpos = $board.position();
			var w = $window.width();
			var nw = $next.width();
			if (bpos.left + 600 + nw + 60 > w) {
				var l = w - bpos.left - nw - 60;
				$next.css("left", l + "px");
				$prev.css("left", l + "px");
			}
		});
		
		// for mobile
		if ($.LiVE.mobile.check) {
			$prev.css({
				left: '400px', bottom: '140px',
				width: '80px', height: '80px',
				backgroundSize: '80px'
			});
			$next.css({
				left: '400px', bottom: '60px',
				width: '80px', height: '80px',
				backgroundSize: '80px'
			});
		}
		
	});
});
