$(function() {
	// 連携キット、local時はexit
	if ($.LiVE.bdkit && location.protocol=="file:") return;
	
	var $panels = $.LiVE.Elements.PANELS.all,
		$window = $.LiVE.Elements.WINDOW;
	
	//パネルセット関数
	$.LiVE.panelstyle.settings = { width: "100%", height: "100%"};
	$.LiVE.panelstyle.func = function(panel,i) {};	//追加関数なし
	$.LiVE.panelstyle.set();
	
	//ナビ
	$.LiVE.navi = {
		duration: "slow",
		easing: "easeOutExpo",
		jump: function(id) {
			var i = parseInt($panels.index($("#"+id)));
			pageScroll("#" + id);
			$.LiVE.currentpanelorder = i;
		},
		prev: function() {
			var i = $.LiVE.currentpanelorder,
				_id = $panels.eq(i).attr("id");
			
			if (i>0) {
				_id = $panels.eq(i-1).attr("id");
				$.LiVE.currentpanelorder = i-1;
				pageScroll("#" + _id);
				return false;
			}
			else if ($.LiVE.Elements.SIDES.siteheader.length>0 && !$.LiVE.Elements.SIDES.menudir && i==0
				&& $.LiVE.side['siteheader'].option.float == false) {
				$.LiVE.navi.pagetop();
			}
		},
		next: function() {
			var i = $.LiVE.currentpanelorder,
				_end = true;
			
			if (i<$panels.length-1) {
				var _id = $panels.eq(i+1).attr("id");
				$.LiVE.currentpanelorder = i+1;
				_end = false;
				
				pageScroll("#" + _id);
				return false;
			} else if ($.LiVE.Elements.SIDES.sitefooter.length>0 && i==$panels.length-1
				&& $.LiVE.side['sitefooter'].option.float == false) {
				pageScroll("#sitefooter");
				return false;
			}
			
			return _end;
		},
		pagetop: function() {
			pageScroll("#pagetop");
			$.LiVE.currentpanelorder = -1;
		}
	};
	
	function pageScroll(panelId) {
		var fblay = $('#fancybox-overlay');
		if ( fblay.length == 0 || fblay.css('display') == "none" ) {
			if (panelId.indexOf('#') != 0) panelId = '#' + panelId;
			
			// iOS5で、position:fixed効かない件
			/*
			if ($.LiVE.mobile.check
				&& ($.LiVE.mobile.type == 'iphone' || $.LiVE.mobile.type == 'ipad')) {
				var div = $('#device');
				if (div.length == 0) {
					$("#base").append($('<div id="device"></div>').css('height', '200px'));
				} else {
					div.css("height", "200px");
				}
			}
			*/
			
			$("html,body").stop().animate({
				scrollTop:$(panelId).offset().top
			},{
				duration:"slow",
				easing:"easeOutQuint",
				complete: function() {
					if ($.LiVE.bdkit==false) location.hash = panelId;
					if (panelId=="#pagetop" || panelId=="#sitefooter") $.LiVE.navicontrol.feedback(panelId.substring(1));
					
					// iOS5で、position:fixed効かない件
					/*
					if ($.LiVE.mobile.check
						&& ($.LiVE.mobile.type == 'iphone' || $.LiVE.mobile.type == 'ipad')) {
						$('#device').css("height", "1px");
					}
					*/
				},
				step: function() {
					if ($.LiVE.mode.name == "edit") animateScroll();
				}
			});
		}
	}
	
	function animateScroll() {
		var wst = $window.scrollTop();
		
		$panels.each(function(){
			var panel = $(this);
			var ph = panel.height();
			var conf = $.LiVE.panel[this.id];
			
			var panelTop = panel.position().top;
			var diff = wst - panelTop;
			if (-5 < diff && diff < ph * .5) {
				$.LiVE.navicontrol.feedback(this.id);
			}
			
			if (conf.data.bganimation && $.LiVE.mobile.check == false) {
				var bg = conf.bg.thunder;
				var pbg = conf.bg.wind;
				
				if (bg[1].length > 0) {
					var bg_isCover = (bg.length > 8 && bg[8]);
					
					// calc offset
					var offset = 0;
					if (bg_isCover) {
						offset = (bg[4]=='top') ? 0:
										(bg[4]=='center') ? ph * 0.2:
										ph * 0.45;	// bottom
					} else {
						var h = bg[7];
						offset = (bg[4]=='top') ? 0:
										(bg[4]=='center') ? (ph - h) / 2:
										ph - h;	// bottom
					}
					
					// animate
					var bxspeed = (bg_isCover) ? 0.8:0.8;
					var bx = panel.find(".box:has(.block)");	//widgetの.boxを除外
					bx.css('backgroundAttachment', 'fixed');
					bx.css('backgroundPosition', bg[3] + ' ' + (offset - diff * bxspeed) + 'px');
					
					if (bg_isCover && $.LiVE.browser.name=="ie8") {		//ie8
						bx.find(".strech-img-box").css("top", (offset - diff * bxspeed) + 'px');
					}
				}
				
				if (pbg[1].length > 0) {
					var pbg_isCover = (pbg.length > 8 && pbg[8]);
					
					// calc offset
					var poffset = 0;
					if (pbg_isCover) {
						/*poffset = (pbg[4]=='top') ? 0:
										(pbg[4]=='center') ? ph * 0.25:
										ph * 0.5;	// bottom*/
					} else {
						var bh = pbg[7];
						poffset = (pbg[4]=='top') ? 0:
										(pbg[4]=='center') ? (ph - bh) / 2:
										ph - bh;	// bottom
					}
					
					// animate
					var pnlSpeed = (pbg_isCover) ? 0.35:0.35;
					panel.css('backgroundAttachment', 'fixed');
					panel.css('backgroundPosition', pbg[3] + ' ' + (poffset - diff * pnlSpeed) + 'px');
					
					if (pbg_isCover && $.LiVE.browser.name=="ie8") {		//ie8
						panel.find(".strech-img").css("top", (poffset - diff * pnlSpeed) + 'px');
					}
				}

			}
		});
	}
	
	// Parallax and Scroll Callback
	$window.bind('scroll', animateScroll);
	
	//キーボード
	var $body = $("body");
	if ($.LiVE.mode.name!="edit") {
		$body
			.bind($.LiVE.Events.KEY_DOWN, $.LiVE.navi.next)
			.bind($.LiVE.Events.KEY_UP, $.LiVE.navi.prev);
		
		// key sound
		$body
			.bind($.LiVE.Events.KEY_DOWN, function() { if ($.LiVE.sesound) $.LiVE.sesound.click();})
			.bind($.LiVE.Events.KEY_UP, function() { if ($.LiVE.sesound) $.LiVE.sesound.click();});
	}
});