
$(function() {

	$.LiVE.opening = {
		activate: $.LiVE.body.opening.activate(),
		set: function() {
			var win = $(window);
			var imgs = $.LiVE.body.opening.slide;
			
			var loop = {
				timer: "",
				interval: $.LiVE.body.opening.duration * 1000 / imgs.length,
				speed: "slow",
				current: 0,
				slide: function() {
					var img = $("img:eq("+loop.current+")", loop.frame);
					img.css({
						marginLeft: win.width() / 2 - img.width() / 2,
						marginTop: win.height() / 2 - img.height() / 2
					});
					img.fadeIn(loop.speed);
					
					if (loop.current > 0) $("img:eq("+(loop.current - 1)+")", loop.frame).stop().fadeOut(loop.speed);
					
					if (loop.current == imgs.length) loop.end();
					
					loop.current++;
				},
				end: function() {
					clearInterval(loop.timer);
					loop.base.animate({
						opacity:0
					},{
						duration: loop.speed,
						complete: function() {
							loop.base.remove();
						}
					});
					if (location.search.match(/mode=presentation/)) {
						$.LiVE.mode.presentation.activate == true;
						$.LiVE.mode.presentation.main();
					}
				},
				set: function() {
					loop.base = $("<div/>").css({
							position: "fixed",
							left: 0,
							top: 0,
							width: "100%",
							height: "100%",
							background: "url(core/opening/slide/bg.png)",
							zIndex:999,
						}).click(function(){
							loop.end();
						}).appendTo("body");
					
					loop.frame = $("<div/>").css({
							margin: "auth auto"
						}).css({
							width: win.width(),
							height: win.height()
						}).appendTo(loop.base);
					
					// load imgs
					var countdownLatch = imgs.length;
					
					for (var i=0;i<imgs.length;i++) {
						var img = $("<img/>").attr({
								src: imgs[i]
							}).css({
								position: "absolute",
								display: "none"
							}).appendTo(loop.frame);
						
						img.imagesLoaded(function(){
							setTimeout( function() { img.attr("width", img.width()).attr("height", img.height()); } ,0 );
							countdownLatch--;
						});
					}
					
					// wait loading
					var init_tm = setInterval(function() {
						if (countdownLatch == 0) {
							clearInterval(init_tm);
							loop.start();
						}
					}, 100);
					
				},
				start: function() {
					loop.slide();
					
					this.timer = setInterval(function() {
						loop.slide();
					}, this.interval);
				}
			};
			
			if (imgs.length>0) {
				loop.set();
			}
		}
	};
});