/*
 * Copyright, digitalstage inc.
 *
 */
// console.log
if (!window.console){
	window.console = {
		log: function(){},
		warn: function(){}
	};
}

// lazy load plugin
jQuery.lazyLoad = function(url, options) {
	options = $.extend(options || {}, {
		dataType: "script",
		cache: true,
		url: url
	});
	
	return $.ajax(options);
};

// do process
$(function() {
	// BiND連携
	$.LiVE.bdkit = false;
	var query = location.search;
	if (query.length > 0) {
		var params = query.substring(1).split("&");
		for (var i=0; i<params.length; i++) {
			var kv = params[ i ].split("=");
			if (kv[0]=="bdkit" && kv[1]=="1") {
				$.LiVE.bdkit = true;
				break;
			}
		}
		
		if ($.LiVE.bdkit && location.protocol=="file:") {
			var div = $('<div><img src="core/common/css/live-offline.png"></div>').css({
				width: 320, height: 400, marginLeft: 'auto', marginRight: 'auto'
			});
			$('<span>サイトをアップロードすると表示されます</span>').css({
				color: '#858585', fontSize: '15px', fontWeight: 'bold'
			}).appendTo(div);
			$('#pagetop').append(div).css('background', '#fff');
			return;
		}
	}
	
	//ブラウザ判定
	var userAgent = window.navigator.userAgent.toLowerCase();
	var appVersion = window.navigator.appVersion.toLowerCase();
	var ngBrowser = "<iframe src='core/browser/index.html' id='browserCheck'>";
	var ngBrowserXP = "<iframe src='core/browser/xp.html' id='browserCheck'>";
	var supportBrowser = true;
	
	if ( userAgent.indexOf('opera') != -1 ) {
		if (forceView()==false) {
			$('#pagetop').html(ngBrowser);
			supportBrowser = false;
		}
	} else if ( userAgent.indexOf("msie") != -1 ) {
		if ( appVersion.indexOf("msie 6.") != -1 && appVersion.indexOf("msie 7.") != -1 ) {
			if ( userAgent.match(/win(dows )?nt 6\.0/) ) {
				if (forceView()==false) {
					$('#pagetop').html(ngBrowser);
					supportBrowser = false;
				}
			} else if ( userAgent.match(/win(dows )?(nt 5\.1|XP)/) ) {
				if (forceView()==false) {
					$('#pagetop').html(ngBrowserXP);
					supportBrowser = false;
				}
			}
		}
	}
	
	// サポートブラウザ以外の時は、これ以降は処理しない
	if (supportBrowser == false) return;
	
	function forceView() {
		return ($.cookie("jp.ds.live.forceView", {path: "/"}) != null);
	}
	
	/********
	モード振り分け
	@jquery
	********/
	$.LiVE.mode = {
		name: "default",
		check: function() {
			var url = document.URL.match(/\?mode/) ? document.URL.match(/\?mode=[a-z]+/).toString().replace(/\?mode=/,"") : "normal";
			switch(url) {
				case "capture":
					this.capture();
					this.name = "capture";
					break;
				case "fullscreen":
					this.fullscreen();
					this.name = "fullscreen";
					break;
				case "presentation":
					this.presentation.main();
					this.presentation.activate = true;
					this.name = "presentation";
					break;
				case "edit":
					this.forcestart();
					this.edit.activate = true;
					this.name = "edit";
					break;
			};
		},
		forcestart: function() {
			if ($.LiVE.loading) $.LiVE.loading.activate = false;
			if ($.LiVE.opening) $.LiVE.opening.activate = false;
		},
		capture: function() {
			this.forcestart();
			$.LiVE.side.sitefooter.option.float = true;
			$.LiVE.Elements.SIDES.sitefooter.remove();					//サイドフッタ系をDOM上から削除
			$.LiVE.Elements.SIDES.pagefooter.remove();
			$.LiVE.Elements.PANELS.all.css({display:"none",overflow:"hidden"}).height(800);
			$.LiVE.Elements.PANELS.all.eq(0).css("display","block");	//最初のパネルのみ表示
			if ($.LiVE.body.scroll=="vertical") $.LiVE.Elements.PANELS.all.eq(1).css("display","block");	//タテの場合2パネル表示
			$.LiVE.Elements.BODY.css("overflow","hidden");				//スクロールバー非表示
			for (keys in $.LiVE.panel) {	//panel animation off
				$.LiVE.panel[keys].data.animation = false;
			}
			// TODO:領域外のウィジェットを消す
		},
		fullscreen: function() {
			//console.log("fullscreen");
		},
		presentation: {
			activate: false,
			main: function() {
				var $body = $("body"),
					$button = $("<div/>").attr("id","presentation_button").appendTo($body),
					auto = {
						timer: "",
						interval: 5000,
						speed: 2500,
						status: false,
						set: function() {
							return this.timer = setInterval(function() {
								var end = $.LiVE.navi.next();
								if (end) clearInterval(auto.timer);
							},this.interval);
						},
						button: function() {
							$button.css({
								left: $(window).width()/2 - $button.width()/2,
								top: $(window).height()/2 - $button.height()
							}).stop().fadeOut("slow");
						},
						pause: function() {
							if (!auto.status) {
								$button.css("display","block").removeClass("play");
								auto.button();
								clearInterval(auto.timer);
								auto.status = true;
							}
							else {
								$button.css("display","block").addClass("play");
								auto.button();
								auto.set();
								auto.status = false;
							}
						}
					};
				
				if (this.activate) auto.set();
				$(window).bind($.LiVE.RESIZE_EVENT, function() {
					auto.button();
				});
				$("html,body").stop().animate({ scrollTop: 0 }, 2000);
				$("#contents").stop().animate({ scrollLeft: 0 }, 2000);
				
				$body.bind($.LiVE.Events.KEY_ENTER, auto.pause);
			}
		},
		edit: {
			activate: false,
			covercss_off: {
				position: "absolute",
				left: -6,
				top: -6,
				border: "4px dotted #ccc",
				borderRadius: "10px",
				zIndex: 3000,
				cursor: "pointer"
			},
			covercss_on: {
				border: "0px"
			},
			off_animation: function() {
				for (keys in $.LiVE.panel) {	//panel animation off
					$.LiVE.panel[keys].data.animation = false;
				}
			},
			resetCover: function() {
				$.LiVE.Elements.PANELS.all.find(".editor-slide, .editor-cov, .editor-info").remove();
				$.LiVE.Elements.PANELS.all.each(function(){
					var p = $(this);
					var blk = p.find(".block");
					var conf = $.LiVE.panel[this.id];
					
					// slide box cover
					var bpos = blk.position();
					if (typeof(conf.tilecss.margin)!="undefined") {
						var vals = conf.tilecss.margin.split(" ");
						var mtop = $.LiVE.util.getNumber(vals[0]);
						if (mtop > 0) bpos.top += mtop;
						var mleft = $.LiVE.util.getNumber(vals[3]);
						if (mleft > 0) bpos.left += mleft;
					}
					var blkcov = $('<div class="editor-slide">')
						.css({
							width: blk.outerWidth(), height: blk.outerHeight(),
							left: bpos.left, top: bpos.top, position: "absolute",
							border: "1px solid rgba(255,255,0,0.5)", zIndex: 50
						}).appendTo(p);
					
					// title & body
					$("header.plate > h1, header.plate > div", this).each(function(){
						var t = $(this);
						var pos = t.position();
						var cov = $('<div class="editor-cov">')
							.css({
								width: t.width()-2, height: t.height(),
								left: pos.left, top: pos.top, position: "absolute",
								border: "1px solid rgba(255,255,0,0.5)", zIndex: 51
							}).appendTo(blk);
						
						var info = $('<div class="editor-info">')
							.css({
								width: "120px", color: "#fff", padding: "5px", position: "fixed",
								marginLeft: "auto", marginRight: "auto", marginTop: "4px",
								borderRadius: "5px", background: "rgba(0, 0, 0, 0.5)", zIndex: 52
							}).appendTo(blk).hide();
						
						info.append("<strong>" + (this.tagName=="H1" ? "スライドタイトル":"スライド本文") + "</strong>");
						info.append("<p>width:" + t.width() + "px</p>");
						info.append("<p>height:" + t.height() + "px</p>");
						
						// hover
						cov.hover(function(){
							info.show();
						}, function(){
							info.hide();
						});
						
						cov.mousemove(function(e){
							info.css({top: e.clientY + 20, left: e.clientX + 20});
						});
					});
				});
			},
			set: function() {
				// display guide.
				this.resetCover();
				$(window).resize(this.resetCover);
				
				// DEFINE roundRect
				CanvasRenderingContext2D.prototype.roundRect = function(x, y, width, 	height, radius) {
					this.moveTo(x+radius, y);
					this.lineTo(x+width-radius, y);
					this.quadraticCurveTo(x+width, y, x+width, y+radius);
					this.lineTo(x+width, y+height-radius);
					this.quadraticCurveTo(x+width, y+height, x+width-radius, y+height);
					this.lineTo(x+radius, y+height);
					this.quadraticCurveTo(x, y+height, x, y+height-radius);
					this.lineTo(x, y+radius);
					this.quadraticCurveTo(x, y, x+radius, y);
				};
				
				var $widgets = $.LiVE.Elements.WIDGETS.all;
				$widgets.each(function() {
					var $this = $(this),
						_id = $this.attr("id");
					
					function getWidgetSize() {
						var _w = $this.width();
						var _h = $this.height();
						if (_w==0 && _h==0) {
							var imz = $this.find("img");
							if (imz.length > 0) {
								_w = imz.width();
								_h = imz.height();
							}
						}
						if (_w==0) _w = 32;
						if (_h==0) _h = 32;
						return {w:_w, h:_h};
					}
					
					var dim = getWidgetSize();
					
					var _cover = $("<div/>")
						.attr("data-edit-id", _id)
						.width(dim.w)
						.height(dim.h)
						.css($.LiVE.mode.edit.covercss_off)
						.click(function() {
							$.LiVE.mode.edit.hideall();
							$("a.widget-del", $widgets).hide();
							$("canvas.live-edit").remove();
							
							var _dim = getWidgetSize();
							
							var pos = $this.position();
							var $canvas = $('<canvas class="live-edit" />')
								.attr('width', _dim.w + 16)
								.attr('height', _dim.h + 16)
								.css({
									position: 'absolute',
									top: -4,
									left: -4,
									zIndex: 3002,
									cursor: 'pointer'
							}).click(function() {
								$.LiVE.widgetedit(_id);
							});
							$this.append($canvas);
							
							var img = new Image();
							img.onload = function() {
								var ctx = $canvas[0].getContext('2d');
								ctx.beginPath();
								
								ctx.lineWidth = 5;
								ctx.strokeStyle = 'black';
								ctx.roundRect(3, 3, _dim.w+2, _dim.h+2, 8);
								ctx.stroke();
								
								ctx.lineWidth = 3;
								ctx.strokeStyle = 'rgb(255,180,0)';
								ctx.roundRect(4, 4, _dim.w, _dim.h, 6);
								
								if (_dim.w > 58 && _dim.h > 30) ctx.drawImage(img, 3, _dim.h-26);
								
								ctx.stroke();
							};
							img.src = 'core/editor/edit.png';
							
							_delbutton.show();
						})
						.prependTo($this);
					
					var _delbutton = $("<a/>")
						.addClass("widget-del")
						.css({
							display: "block",
							width: 32,
							height: 32,
							background: "url(core/editor/panel-icon-delete.png) no-repeat",
							position: "absolute",
							top: _cover.height() - 16,
							left: _cover.width() - 16,
							zIndex:3003
						})
						.click(function(){
							$.LiVE.widgetdelete(_id);
							return false;
						})
						.mouseenter(function(){
							_delbutton.css("background", "url(core/editor/panel-icon-delete-hold.png) no-repeat");
						})
						.mouseleave(function(){
							_delbutton.css("background", "url(core/editor/panel-icon-delete.png) no-repeat");
						})
						.prependTo($this)
						.hide();
				});
			},
			hideall: function() {
				$("div[data-edit-id]").css($.LiVE.mode.edit.covercss_off);
			},
			hide: function(wid) {
				$("div[data-edit-id=" + wid + "]").css($.LiVE.mode.edit.covercss_off);
			},
			select: function(wid) {
				$("div[data-edit-id=" + wid + "]").click();
			}
		}
	};
	
	/********
	端末判断
	********/
	$.LiVE.mobile = {
		type: "none",
		check: false,
		ua: function() {
			var val = false;
			
			if (userAgent.match(/iphone/)) {
				this.type = "iphone";
				val = true;
			}
			else if (userAgent.match(/ipad/)) {
				this.type = "ipad";
				val = true;
			}
			else if (userAgent.match(/android/)) {
				this.type = "android";
				val = true;
			}
			
			if (val) $.LiVE.mode.forcestart();	//loading,opening削除
			this.check = val;
		}
	};
	$.LiVE.mobile.ua();
	
	/********
	window高さ取得。iPhoneでも取得。
	********/
	$.LiVE.winHeight = function() {
		if ($.LiVE.mobile.check) return window.innerHeight || $(window).height();
		return $(window).height();
	};
	
	/**
	tileの実高さ取得。
	**/
	$.LiVE.getTileHeight = function(pid) {
		var confH = $.LiVE.panel[pid].tilecss.height;
		if (typeof(confH) != 'undefined' && confH.length > 0) {
			if (confH.indexOf('%') > -1) {
				var h = $.LiVE.winHeight();
				return h * (confH.substring(0, confH.length-1) / 100);
			} else {
				return confH;
			}
		} else {
			return $('#' + pid).find('.block').height();
		}
	};
	
	//リサイズイベント名
	$.LiVE.RESIZE_EVENT = "resize";
	if ($.LiVE.mobile.check) {
		$.LiVE.RESIZE_EVENT = "orientationchange";
	}
	
	/********
	パネルサイズ設定
	********/
	//pxを省いてnumber型で返す関数
	function nopxNum(pxNum) {
		if (pxNum == 'auto' || typeof(pxNum) == 'undefined') return 0;
		var num = pxNum.replace('px','');
		num = num.replace('%','');
		return parseInt(num);
	}
	
	$.LiVE.getPanelIndex = function(pid) {
		if (pid == "pagetop") return -1;
		if (pid == "sitefooter") return $.LiVE.Elements.PANELS.all.length;
		var idx = 0;
		for (var k in $.LiVE.panel) {
			if (k == pid) return idx;
			idx++;
		}
		return -1;
	};
	
	$.LiVE.currentpanelorder = 0;	//カレント表示パネル番号　※各テンプレート$.LiVE.navi変数で参照・上書き
	if (location.hash.length > 0) {
		$.LiVE.currentpanelorder = $.LiVE.getPanelIndex(location.hash.substring(1));
	}
	$.LiVE.panelresizeset = function() {	//ウィンドウリサイズ時のパネル挙動　※各テンプレートから上書きアリ
		var target = location.hash;
		if (target.length == 0) {
			target = "body";
		}
		
		var $anchor = $(target);
		
		$.LiVE.Elements.BODY.stop().animate({
			scrollTop: $anchor.offset().top,
			scrollLeft: $anchor.offset().left
		}, "fast");
	};
	
	$.fn.hidePageScroller = function() {
		var scrollSet = $.LiVE.body.hidescrollbar,
			body = $('body');
		
		if ( scrollSet ) {
			body.css('overflow','hidden');
		}
	}
	
	// half時のサイズ調整処理
	$.LiVE.panelSizeResult = function(panel) {
		var	$this = $(panel),
			$block = $this.find('.block'),
			$plate = $block.find('header.plate'),
			blockW = $block.outerWidth(true),
			plateW = $plate.outerWidth(true),
			plateh1 = $plate.find('h1.panel-title'),
			plateDesc = $plate.find('div.panel-description'),
			blockMarR = $block.css('marginRight'),
			blockMarL = $block.css('marginLeft'),
			blockPadR = $block.css('paddingRight'),
			blockPadL = $block.css('paddingLeft'),
			plateh1MarR = plateh1.css('marginRight'),
			plateh1MarL = plateh1.css('marginLeft'),
			plateh1PadR = plateh1.css('paddingRight'),
			plateh1PadL = plateh1.css('paddingLeft'),
			plateDescMarR = plateDesc.css('marginRight'),
			plateDescMarL = plateDesc.css('marginLeft'),
			plateDescPadR = plateDesc.css('paddingRight'),
			plateDescPadL = plateDesc.css('paddingLeft'),
			negMP = nopxNum(blockMarR) + nopxNum(blockMarL) + nopxNum(blockPadR) + nopxNum(blockPadL),
			plateh1MP = nopxNum(plateh1MarR) + nopxNum(plateh1MarL) + nopxNum(plateh1PadR) + nopxNum(plateh1PadL) + nopxNum(blockPadL),
			plateDescMP = nopxNum(plateDescMarR) + nopxNum(plateDescMarL) + nopxNum(plateDescPadR) + nopxNum(plateDescPadL) + nopxNum(blockPadR);
			
		plateh1.width(plateW/2 - plateh1MP);
		plateDesc.width(plateW/2 - plateDescMP);
	}
	
	$.fn.panelsizeadjust = function(settings) {
		if (!settings) var settings = { width: "", height: "" };
		var $this = $(this),
			$window = $.LiVE.Elements.WINDOW,
			$box = $this.find(".box:has(.block)"),
			$main = $.LiVE.Elements.MAIN,
			$contents = $.LiVE.Elements.CONTENTS,
			w = $this.width(),
			h = $this.height(),
			id = $this.attr("id"),
			val = $.LiVE.panel[id];

		function mainwidth() {
			var _width = $window.width();
			if ( val.css['border-width'] ) {
				var	borderLeft = $box.css('borderLeftWidth'),
					borderRight = $box.css('borderRightWidth');
				_width = $window.width() - nopxNum(borderLeft) - nopxNum(borderRight);
			}
			return _width;
		}
		
		function mainheight() {
			var _height = $.LiVE.winHeight(),
				base = $('#base'),
				boxs = $('#contents').find('section').find('.box'),
				header = $.LiVE.Elements.SIDES.siteheader,
				footer = $.LiVE.Elements.SIDES.sitefooter,
				headerJson = $.LiVE.side["siteheader"],
				footerJson = $.LiVE.side["sitefooter"],
				pageheader = $.LiVE.Elements.SIDES.pageheader,
				pagefooter = $.LiVE.Elements.SIDES.pagefooter,
				headerH = header.outerHeight(true),
				footerH = footer.outerHeight(true),
				headerPos = header.css('position'),
				footerPos = footer.css('position');
			
			if ( $.LiVE.body.scroll == "vertical" ) {
				//縦型スクロールの時
				base.css('padding',0);
			} else if ( $.LiVE.body.scroll == "" ) {
				//横型スクロールの時
				if ( $.LiVE.Elements.SIDES.siteheader.isVertical == true ) {
					//グローバルナビが縦の時
					if ( !footerJson.option["float"] ) {
						_height -= footerH;
					}
					base.css('padding',0);
					if ( pageheader.size() > 0 ) _height -= pageheader.outerHeight(true);
					if ( pagefooter.size() > 0 ) _height -= pagefooter.outerHeight(true);
				} else if ( $.LiVE.Elements.SIDES.siteheader.isVertical == false ) {
					//グローバルナビが横の時
					if ( headerJson.option["float"] ) {
						if ( !footerJson.option["float"] ) {
							_height -= footerH;
						}
					} else {
						_height -= headerH;
						if ( !footerJson.option["float"] ) {
							_height -= footerH;
						}
					}
					base.css('padding',0);
					if ( pageheader.size() > 0 ) _height -= pageheader.outerHeight(true);
					if ( pagefooter.size() > 0 ) _height -= pagefooter.outerHeight(true);
				}
			}
			return _height;
		}
		
		if ( $.LiVE.body.scroll== "" ) {	//横スクロールの場合
			if ($.LiVE.Elements.SIDES.siteheader.length > 0) {
				$.LiVE.Elements.SIDES.siteheader.sidefloatset();
			}
			if ($.LiVE.Elements.SIDES.sitefooter.length > 0) {
				$.LiVE.Elements.SIDES.sitefooter.sidefloatset();
			}
		}
		var size = {
				self: $this,
				width: function() {
					var _width = mainwidth();
					return _width;
				},
				height: function() {
					var _height = this.self.height();
					if ($.LiVE.body.scroll=="vertical") {
						_height = mainheight();
					}
					else if ($.LiVE.body.scroll=="") {
						$main.height(mainheight());
						_height = mainheight();
					}
					return _height;
				},
				adjust: function() {	//boxサイズ設定
					$box.width(size.width());
					$box.height(size.height());
				}
			};
		
		size.adjust();
		
		$window.bind($.LiVE.RESIZE_EVENT, function() {	//リサイズ時調整
			// mobile時の高さ調整
			if ($.LiVE.mobile.check) {
				// hide addressbar
				hideMobileAddressBar();
				
				var minH = $.LiVE.winHeight();
				if ($.LiVE.body.scroll == "" && $.LiVE.Elements.SIDES.siteheader.length > 0) {
					minH -= $.LiVE.Elements.SIDES.siteheader.outerHeight(true);
				}
				$.LiVE.Elements.PANELS.all.css("minHeight", minH);
				$.LiVE.Elements.PANELS.all.find("> .box").css("minHeight", minH);
				
				// tileの表示高さ調整
				optimizeMobileTileSize();
				
				// imgタグがある場合の調整
				mobileImgResized();
			}
			size.adjust();
			if ( !$.LiVE.mobile.check ) $.LiVE.panelresizeset();
		});
	};
	
	/********
	背景画像設定
	********/
	function bgset(e,css,mobile_check) {
		if (typeof(css)=='undefined') return;
		var bgpath = (css[1] == "none" || css[1] == "") ? "" : "url("+css[1]+")",
			bgsize = "auto";
		if (bgpath.length > 0) {
			
			if (mobile_check && $.LiVE.mobile.check) {
				// モバイル画像へ入れ替え
				var pos = bgpath.lastIndexOf(".");
				bgpath = bgpath.substring(0, pos) + "_4" + bgpath.substring(pos);
			}
			
			if (css[8]) {
				bgsize = "cover";
				if ($.LiVE.browser.name=="ie8") {	//ie8
					e.legacyBackgroundStrech(css[1], css[3], css[4], css[0]);
					
					e.find(".box").css({position: "relative", zIndex: 1});
					e.find(".block").css("zIndex", 2);
					
					return;
				} else {
					e.css("background-image", bgpath);
				}
			} else {
				e.css("background-image", bgpath);
			}
		}
		
		e.css({
			"background-color": css[0],
			"background-repeat": css[2],
			"background-position": css[3] + " " + css[4],
			"background-attachment": css[5],
			"background-size": bgsize
		});
	}
	
	// ie8向け背景ストレッチ
	$.fn.legacyBackgroundStrech = function(src, posX, posY, color) {
		this.each(function(){
			var	$this = $(this),
					$win = $(window);
			
			var wrap = $('<div>').css({
				position: 'absolute', left: 0, top:0,
				width: '100%', height: '100%',
				overflow: 'hidden',
				zIndex: $this.hasClass("box") ? 1:0,
				backgroundColor: color
			}).appendTo($this);
			
			var img = $('<img src="' + src + '" class="strech-img' + ($this.hasClass("box") ? '-box':'') + '">');
			img.css({
				position: 'absolute'
			}).appendTo(wrap);
			
			if (posX == 'right') img.css('right', 0);
			if (posY == 'bottom') img.css('bottom', 0);
			
			$win.bind($.LiVE.RESIZE_EVENT, function(){
				var	winW = $win.width(),
						winH = $.LiVE.winHeight();
				
				img.css({
					width: winW,
					height: 'auto'
				});
				
				if (img.height() < winH) {
					img.css({
						height: winH,
						width: 'auto'
					});
				}
				
				if (posX == 'center') {
					var imgW = img.width();
					img.css('left', parseInt((winW - imgW) / 2));
				}
				
				if (posY == 'center') {
					var imgH = img.height();
					img.css('top', parseInt((winH - imgH) / 2));
				}
			});
		});
	};
	
	$.fn.bodybgset = function() {
		var val = $.LiVE.body,
			$wind = $("#pagetop"),
			$thunder =$("#base");
		if (val.bg.wind) bgset($wind,val.bg.wind);
		if (val.bg.thunder) bgset($thunder,val.bg.thunder);
	};
	$.fn.sidebgset = function() {
		var id = $(this).attr("id"),
			val = $.LiVE.side[id],
			$box = $(".box",this);
		
		if (val.bg.full) bgset($(this),val.bg.full);
		if (val.bg.fit) bgset($box,val.bg.fit);
	};
	$.fn.panelbgset = function() {
		var $this = $(this),
			$box = $this.find(".box:has(.block)"),
			$block = $this.find(".block"),
			id = $this.attr("id"),
			val = $.LiVE.panel[id];
		
		if (val.bg.wind) bgset($this, val.bg.wind, true);
		if (val.bg.thunder) bgset($box, val.bg.thunder, true);
		if (val.tilebg[0]) bgset($block, val.tilebg[0]);
	};
	$.fn.menubgset = function() {
		var val = $.LiVE.side.siteheader,
			$sitemenu = $(this),
			$sitemenuList = $sitemenu.find('li'),
			a = $sitemenu.find("a"),
			p = a.find("p"),
			tp = $sitemenu.find('p'),
			td = $sitemenu.find('div'),
			current = $sitemenu.find(".on a");
		
		if (!val) return;
		if ( val.menubg ) bgset($sitemenuList,val.menubg);
	};
	$.fn.widgetbgset = function() {
		var $this = $(this),
			id = $this.attr("id"),
			val = $.LiVE.widget[id];
		if (val.bg.length) bgset($this.find(".box"),val.bg[0]);
	}
	
	/********
	追加CSS設定
	********/
	$.fn.sideoptioncssset = function() {
		var $this = $(this),
			id = $this.attr("id"),
			val = $.LiVE.side[id],
			$box = $this.find(".box");
		if (val.css) {
			for (keys in val.css) {
				if(keys.indexOf("margin")>-1) {
					var m = val.css[keys].split(" ");
					$this.css({
						"margin-top": m[0],
						"margin-bottom": m[2],
						"margin-right": m[1],
						"margin-left": m[3]
					});
				} else {
					$box.css(keys, val.css[keys]);
				}
			}
		}
	};
	$.fn.paneloptioncssset = function() {
		var $this = $(this),
			id = $this.attr("id"),
			val = $.LiVE.panel[id],
			$window = $(window),
			$box = $this.find(".box:has(.block)"),
			$block = $this.find(".block"),
			$title = $this.find(".panel-title"),
			$description = $this.find(".panel-description");
		
		if (val.css) {
			for (keys in val.css) {
				if(keys.indexOf("border")>-1) {
					$box.css(keys, val.css[keys]);
				}
				else if(keys.indexOf("margin")>-1) {
					$this.css(keys, val.css[keys]);
				}
				else if(keys.indexOf("color")>-1) {
					$block.css(keys, val.css[keys]);
				}
				else if(keys.indexOf("width")>-1) {
					$block.css(keys, val.css[keys]);
				}
				else if(keys.indexOf("height")>-1) {
					$block.css(keys, val.css[keys]);
					if ($.LiVE.mobile.check) $block.css({'minHeight': val.css[keys],"height":"auto"});
				}
				else {
					$this.css(keys, val.css[keys]);
				}
				
				//パネル背景にも角丸適用
				if(keys=="border-radius") {
					$this.css(keys, val.css[keys]);
				}
			}
		}
		if (val.tilecss) {
			var tileMargin = $.LiVE.util.splitCSS(val.tilecss.margin);
			var tilePadding = $.LiVE.util.splitCSS(val.tilecss.padding);
			
			// height
			if (tileMargin.top > 0) $block.css("marginTop", tileMargin.top);
			if (tileMargin.bottom > 0) $block.css("marginBottom", tileMargin.bottom);
			if (tilePadding.top > 0) $block.css("paddingTop", tilePadding.top);
			if (tilePadding.bottom > 0) $block.css("paddingBottom", tilePadding.bottom);
			
			if (val.tilecss.height) {
				if (val.tilecss.height == "100%") {
					var tile_resize = function(){
						var _h = $.LiVE.winHeight() - tileMargin.top - tileMargin.bottom;
						if ($.LiVE.mobile.check && $.LiVE.body.scroll == "") { // mobileで横スク
							if ($.LiVE.Elements.SIDES.siteheader.length > 0) _h -= $.LiVE.Elements.SIDES.siteheader.height();
						}
						$block.css("height", _h);
					};
					tile_resize();
					$window.bind($.LiVE.RESIZE_EVENT, tile_resize);
				} else {
					$block.css("height", val.tilecss.height);
				}
			}
			
			// width
			if (tileMargin.left > 0) $block.css("marginLeft", tileMargin.left);
			if (tileMargin.right > 0) $block.css("marginRight", tileMargin.right);
			if (tilePadding.left > 0) $block.css("paddingLeft", tilePadding.left);
			if (tilePadding.right > 0) $block.css("paddingRight", tilePadding.right);
			
			if (val.tilecss.width) {
				if (val.tilecss.width == "100%") {
					$window.bind($.LiVE.RESIZE_EVENT, function(){
						var _w = $window.width() - tileMargin.left - tileMargin.right;
						$block.css("width", _w);
					});
					
				} else {
					$block.css("width", val.tilecss.width);
				}
			}
			
			for (keys in val.tilecss) {
				if(keys.indexOf("border")>-1) {
					$block.css(keys, val.tilecss[keys]);
				}
			}
		}
		if (val.data.titleLineHeight) {
			$title.css("line-height", val.data.titleLineHeight);
		}
		if (val.data.descriptionLineHeight) {
			$description.css("line-height", val.data.descriptionLineHeight);
		}
		if (val.title) {
			for ( keys in val.title ) {
				$title.css(keys,val.title[keys]);
			}
		}
		if (val.desc) {
			for ( keys in val.desc ) {
				$description.css(keys,val.desc[keys]);
			}
		}
	};
	$.fn.verticalcssset = function() {
		var header = $.LiVE.Elements.SIDES.siteheader;
		if ( $.LiVE.Elements.SIDES.siteheader.isVertical == true ) {
			var val = $.LiVE.side['siteheader'];
			header.width(val.css.width);
		}
	};
	
	// サイトヘッダーの高さ計算。
	function calcSiteHeaderHeight() {
		//サイトヘッダ内レイアウト
		var $siteheader = $.LiVE.Elements.SIDES.siteheader,
			$box = $siteheader.find(".box"),
			$logo1 = $siteheader.find(".logo1"),
			$logo2 = $siteheader.find(".logo2"),
			$menu = $.LiVE.Elements.SIDES.sitemenu,
			$ul = $menu.find("ul"),
			list = $menu.find('li'),
			_width = 0,
			_height = 0,
			logo1H = $logo1.outerHeight(true),
			logo2H = $logo2.outerHeight(true);
		
		var overcssBW = $.LiVE.side.siteheader.overcss['border-width'],
			currentcssBW = $.LiVE.side.siteheader.currentcss['border-width'],
			borderWidth;
		//マウスオーバーかカレント時にボーダーが入っていれば値を代入する
		if (overcssBW) {
			overcssBW = overcssBW.split('px ');
			overcssBW = overcssBW[0] * 2;
		}
		if (currentcssBW) {
			currentcssBW = currentcssBW.split('px ');
			currentcssBW = currentcssBW[0] * 2;
		}
		
		//マウスオーバー、カレント時に入っている値が大きい方をborderWidthに入れてメニューの数分掛ける
		if (overcssBW || currentcssBW) {
			if ( overcssBW && currentcssBW ) {
				borderWidth = overcssBW > currentcssBW ? overcssBW : currentcssBW;
			} else if ( overcssBW ) {
				borderWidth = overcssBW;
			} else if ( currentcssBW ) {
				borderWidth = currentcssBW;
			}
		}
		
		var menuH = list.height() +
			nopxNum(list.css('marginTop')) + nopxNum(list.css('marginBottom')) + nopxNum(list.css('paddingTop')) + nopxNum(list.css('paddingBottom')) +
			(borderWidth ? borderWidth:0);
		
		$menu.css({
			marginLeft: $logo1.outerWidth(true),
			marginRight: $logo2.outerWidth(true)
		});
		
		_height = menuH;
		if (logo1H > _height) _height = logo1H;
		if (logo2H > _height) _height = logo2H;
		
		var newMenuH = $menu.outerHeight(true);
		if (newMenuH == 0) newMenuH = $ul.outerHeight(true);
		if (_height < newMenuH) _height = newMenuH;
		$box.height(_height);
		
		$menu.css({
			paddingTop: _height/2 - menuH/2
		});
	}
	
	$.fn.menuoptioncssset = function() {
		var $sitemenu = $(this),
			val = $.LiVE.side.siteheader,
			a = $sitemenu.find("a"),
			current = $sitemenu.find(".on"),
			list = $sitemenu.find("li"),
			td = $sitemenu.find('p'),
			$logo1 = $("div.logo1"),
			$logo2 = $("div.logo2");
		if (!val) return;
		
		//メニューのcssを適用する
		for (keys in val.menucss) {
			list.css(keys, val.menucss[keys]);
		}
		if (val.menucss.color) a.css("color",val.menucss.color);
		
		if (val.logo1css) {
			for (keys in val.logo1css) {
				var m = val.logo1css[keys].split(" ");
				$logo1.css({
					"marginTop": m[0],
					"marginRight": m[1],
					"marginBottom": m[2],
					"marginLeft": m[3]
				});
			}
		}
		if (val.logo2css) {
			for (keys in val.logo2css) {
				var m = val.logo2css[keys].split(" ");
				var mr = val.logo2css[keys].split("px ");
				var mr1 = parseInt(mr[1]);
				var logo2right =  mr1 + $logo2.width();
				$logo2.css({
					"marginTop": m[0],
					"marginRight": logo2right,
					"marginBottom": m[2],
					"marginLeft": m[3]
				});
			}
		}
		
		//メニューのマウスオーバー指定 例外として背景も一緒に指定
		list.each(function(){
			var $this = $(this),
				this_anchor = $this.find('a'),
				menuNowColor = $this.find('a').css('color'),
				menuNow = [];
				menuNow[0] = $this.css('backgroundImage');
				menuNow[1] = $this.css('backgroundColor');
				menuNow[2] = $this.css('backgroundRepeat');
				menuNow[3] = $this.css('backgroundPosition');
				menuNow[4] = $this.css('backgroundAttachment');
				menuNow[5] = $this.css('backgroundSize');
			$this.hover(function() {
				if (val.overbg) bgset($this,val.overbg);
				for (keys in val.overcss) {
					$this.css(keys, val.overcss[keys]);
					if ( keys == "color" ) this_anchor.css(keys, val.overcss[keys]);
				}
				$this.css('backgroundRepeat','no-repeat');
				if ( $this.hasClass('menuBgIconRight') ) $this.css('backgroundPosition','right top');
			},function() {
				if (val.menubg) {
					bgset($this,val.menubg);
					$this.css({
						'backgroundRepeat':'no-repeat',
						'border':'none'
					});
					if ( $this.hasClass('menuBgIconRight') ) $this.css('backgroundPosition','right top');
				} else {
					$this.css({
						'backgroundImage': menuNow[0],
						'backgroundColor': menuNow[1],
						'backgroundRepeat': menuNow[2],
						'backgroundPosition': menuNow[3],
						'backgroundAttachment': menuNow[4],
						'backgroundSize': menuNow[5],
						'border':'none'
					});
					this_anchor.css('color',menuNowColor);
				}
				if (val.menucss) {
					for (keys in val.menucss) {
						$this.css(keys, val.menucss[keys]);
						if ( keys == "color" ) this_anchor.css(keys, val.menucss[keys]);
					}
				}
				$this.css('backgroundRepeat','no-repeat');
				if ( $this.hasClass('on') ) {
					for (keys in val.currentcss) {
						$this.css(keys, val.currentcss[keys]);
						if ( keys == "color" ) this_anchor.css(keys, val.currentcss[keys]);
					}
					bgset($this,val.currentbg);
					$this.css('backgroundRepeat','no-repeat');
					if ( $this.hasClass('menuBgIconRight') ) $this.css('backgroundPosition','right top');
				}
			});
		});
		
		// 高さ計算
		// large系とvertical系は不要
		if ($.LiVE.Elements.SIDES.siteheader.length > 0 && $.LiVE.Elements.SIDES.siteheader.isVertical == false) {
			var $box = $.LiVE.Elements.SIDES.siteheader.find(".box");
			if ($box[0].className.indexOf("large") == -1) {
				$window.bind($.LiVE.RESIZE_EVENT, calcSiteHeaderHeight);
			}
		}
	};
	$.fn.widgetoptioncssset = function() {
		var $this = $(this),
			$window = $(window),
			$box = $this.find(".box"),
			id = $this.attr("id"),
			val = $.LiVE.widget[id];
		if (val.css) {
			for (keys in val.css) {
				if (keys.indexOf("width")>-1) {
					if (!$.LiVE.body.scroll && val.option.float && val.css[keys]=="100%") {
						$this.css("width", $window.width());
						$window.bind($.LiVE.RESIZE_EVENT, function() {
							$this.css("width", $window.width());
						});
					}
					else {
						$this.css(keys, val.css[keys]);
					}
					$box.css("width", "100%");
				} else if (keys.indexOf("height")>-1) {
					$box.css(keys, val.css[keys]);
					$this.css(keys, val.css[keys]);
					
				} else if (keys.indexOf("border-color")>-1) {
					$this.css(keys,val.css[keys]);
				} else if (keys.indexOf("border-style")>-1) {
					$this.css(keys,val.css[keys]);
				} else if (keys=="border-radius") {
					$this.css(keys, val.css[keys]);
					$box.css(keys, val.css[keys]);
				}
				else $box.css(keys, val.css[keys]);
			}
		}
		
		// モバイル＆横スク時は左右ボタンをリサイズ
		if ($.LiVE.mobile.check && $.LiVE.mobile.type != 'ipad' && $.LiVE.body.scroll == ""
			&& $this.hasClass("navi") && ($this.find(".default_prev").length>0 || $this.find(".default_next").length>0)) {
			$this.doubleSize();
		}
		
	};
	
	// サイズ倍化。timeに倍率指定可。
	$.fn.doubleSize = function(time) {
		var tm = time || 2;
		this.each(function() {
			var $this = $(this),
				$box = $this.find(".box");
			var w = $this.width();
			var h = $this.height();
			var css = {
				width: w * tm,
				height: h * tm,
				backgroundSize: (w * tm) + "px " + (h * tm) + "px"
			};
			$this.css(css);
			if ($box.length>0) $box.css(css);
		});
	};
	
	$.fn.headercssset = function() {
		var $this = $(this),
			id = $this.attr("id"),
			val = $.LiVE.side[id],
			$box = $this.find(".box"),
			align = $.LiVE.side['siteheader'].position;

			if ( $.LiVE.Elements.SIDES.siteheader.isVertical == true ) {
				var $headBox = $('#siteheader').find('.vertical,.vertical_center');
				for ( keys in val.css ) {
					if (keys.indexOf("padding")>-1) {
						$headBox.css("padding", val.css[keys]);
					}
				}
				var boxPl = $headBox.css('paddingLeft'),
					boxPr = $headBox.css('paddingRight'),
					boxMl = $headBox.css('marginLeft'),
					boxMr = $headBox.css('marginRight'),
					boxPlLen = boxPl.length,
					boxPrLen = boxPr.length,
					boxMlLen = boxMl.length,
					boxMrLen = boxMr.length,
					boxPlpx = boxPl.replace("px",""),
					boxPrpx = boxPr.replace("px",""),
					boxMlpx = boxMl.replace("px",""),
					boxMrpx = boxMr.replace("px",""),
					boxWid = $headBox.width() - boxPlpx - boxPrpx - boxMlpx - boxMrpx;
				if ( align == "right" ) {
					$headBox.css({'width':boxWid + 'px','float':'none','textAlign':'right'});
				} else if ( align == "center" ) {
					$headBox.css({'width':boxWid + 'px','float':'none','textAlign':'center'});
				} else {
					$headBox.css('width',boxWid + 'px');
				}
			}
	};
	$.fn.imgalign = function() {
		var panelimg = $('div.panel-description').find('img');
		if ( panelimg ) {
			panelimg.each( function() {
				var $this = $(this),
					imgAlign = $this.attr('align');
				switch( imgAlign ) {
					case "left":
						$this.css('padding','0 15px 15px 0');
					break;
					case "right":
						$this.css('padding','0 0 15px 15px');
					break;
				}
			});
		}
	};
	
	/********
	ポジション設定
	********/
	$.fn.sidepositionset = function() {
		var $this = $(this),
			id = $this.attr("id"),
			val = $.LiVE.side[id],
			$box = $this.find(".box");
		if (!val.position) val.position = "center";
		switch(val.position) {
			case "left": break;
			case "right": $box.css("float","right");break;
			case "center": $box.css("margin","0 auto");break;
		}
	};
	var poscalc = {
		stagewidth: function(stage) {
			return stage.width();
		},
		stageheight: function(stage) {
			var _h = stage.height();
			var _winH = $.LiVE.winHeight();
			if ($.LiVE.mobile.check || _h > _winH) _h = _winH;
			return _h;
		},
		selfwidth: function(self) {
			return self.outerWidth(true);
		},
		selfheight: function(self) {
			return self.outerHeight(true);
		},
		left: function(stage,self) {
			var _x = this.stagewidth(stage)/2 - this.selfwidth(self)/2;
			_x -= $.LiVE.util.getNumber(self.css("marginRight"));
			return _x < 0 ? 0 : _x;
		},
		top: function(stage,self) {
			var _y = this.stageheight(stage)/2 - this.selfheight(self)/2;
			return _y < 0 ? 0 : _y;
		},
		gapx: function(stage,self) {
			return stage.width() - self.width();
		},
		gapy: function(stage,self) {
			return stage.height() - self.height();
		}
	};
	$.fn.tilepositionset = function() {
		
		var $this = $(this),
			$window = $(window),
			id = $this.attr("id"),
			val = $.LiVE.panel[id],
			$block = $this.find(".block");
		
		if (!val.tileposition) val.tileposition = [ "left", "top" ];
		
		if (val.tilecss.width && val.tilecss.width != "100%") {
			switch(val.tileposition[0]) {//横
				case "left":
					$block.css("left","0");
					$window.bind($.LiVE.RESIZE_EVENT, function() {//リサイズ調整
						$block.css("left","0");
						if ($.LiVE.mobile.check) {
							var w = $block.outerWidth(true),
								_left = $.LiVE.util.getNumber($block.css("left")),
								winW = $window.width();
							if (w + _left > winW) {
								$block.css("left", winW - w);
							}
						}
					});
					break;
				case "right": $block.css("right","0");break;
				case "center":
					$block.css("left",poscalc.left($this,$block));
					$window.bind($.LiVE.RESIZE_EVENT, function() {//リサイズ調整
						var _left = poscalc.left($("#"+id), $block);
						$block.css("left", _left);
						if ($.LiVE.mobile.check) {
							var w = $block.outerWidth(true),
								winW = $window.width();
							if (w + _left > winW) {
								$block.css("left", winW - w);
							}
						}
					});
					break;
				default: $block.css("left","0");
			}
		}
		
		if (val.tilecss.height && val.tilecss.height !="100%") {
			switch(val.tileposition[1]) {//たて
				case "top": $block.css("top","0");break;
				case "bottom": $block.css("bottom","0");break;
				case "center":
					$block.css("top",poscalc.top($this,$block));
					$window.bind($.LiVE.RESIZE_EVENT, function() {//リサイズ調整
						$block.css("top",poscalc.top($("#"+id),$block));
					});
					break;
				default: $block.css("top","0");
			}
		}
	};
	
	$.fn.widgetpositionset = function() {
		var $this = $(this),
			id = $this.attr("id"),
			val = $.LiVE.widget[id],
			_x = val.position.x[1],
			_y = val.position.y[1],
			stage = val.option.float ? $(window) : $("#" + val.option.fixedTo);
		
		if (!val.option.float) $this.appendTo($("#" + val.option.fixedTo));
		
		$this.css({"left":"auto","right":"auto","top":"auto","bottom":"auto"});
		switch(val.position.x[0]) {//横
			case "left":
				$this.css("left",_x);
				$(window).bind($.LiVE.RESIZE_EVENT, function() {
					$this.css("left",_x);
					// mobile時
					if ($.LiVE.mobile.check) {
						var winW = $(window).width(),
							pos = $this.position(),
							w = $this.width();
						// 右
						if (pos.left + w > winW) {
							$this.css("left", winW - w);
						}
					}
				});
				break;
			case "right":
				$this.css("right",_x);
				break;
			case "center":
				$this.css("left",poscalc.left(stage,$this) - _x);
				$(window).bind($.LiVE.RESIZE_EVENT, function() {
					$this.css("left",poscalc.left(stage, $this) - _x);
					// mobile時
					if ($.LiVE.mobile.check) {
						if (val.css.width != '100%' && $this.position().left < 4) $this.css("left", 4);
						var winW = $(window).width(),
							pos = $this.position(),
							w = $this.width();
						// 左
						if (pos.left < 0) {
							$this.css("left", 0);
						}
						// 右
						if (pos.left + w > winW) {
							$this.css("left", winW - w);
						}
					}
				});
				break;
			defalt: $this.css("left","0");
		}
		switch(val.position.y[0]) {
			case "top": $this.css("top",_y);break;
			case "bottom":
				$this.css("bottom",_y);
				break;
			case "center":
				$this.css("top",poscalc.top(stage,$this) + _y);
				$(window).bind($.LiVE.RESIZE_EVENT, function() {
					$this.css("top",poscalc.top(stage,$("#"+id)) + _y);
				});
				break;
			default: $this.css("top","0");
		}
		
		if (val.option.float) $this.css("position", "fixed");
		
	};
	
	/********
	z-index設定
	********/
	$.fn.widgetzindexset = function() {
		var $this = $(this),
			id = $this.attr("id"),
			val = $.LiVE.widget[id];
		$this.css("z-index",val.z + $.LiVE.zindex.widget);
		if (val.z > $.LiVE.zindex.max) $.LiVE.zindex.max = val.z;
	};
	
	/********
	サイドカラム幅
	********/
	$.fn.sidecolumnwidthset = function() {
		var id = $(this).attr("id");
		if (id.match(/siteheader/)) return;
		
		var $box = $(".box",this),
			col = $box.attr("class").match(/x[0-9]/).toString(),
			val = $.LiVE.side[id];
		function cssset(e) {
			$(e,$box).each(function() {
				var c = $(this).attr("class");
				for (keys in val.column[c]) $(this).css(keys, val.column[c][keys]);
			});
		}
		switch(col) {
			case "x1": cssset(".a"); break;
			case "x2": cssset(".a, .b"); break;
			case "x3": cssset(".a, .b, .c"); break;
			case "x4": cssset(".a, .b, .c, .d"); break;
			case "x5": cssset(".a, .b, .c, .d, .e"); break;
		}
	};
	
	/********
	サイトサイド位置固定／押し出し／自動隠し
	********/
	$.fn.sidefloatset = function() {
		var $this = $(this),
			id = $this.attr("id");
		if (id.match(/page/)) return;
		if (id.match(/siteheader/) && $.LiVE.Elements.SIDES.menudir) return;
		
		var val = $.LiVE.side[id],
			$base = $("#base");
		
		$base.css({ padding: 0 });	//floatリセット用
		
		if (val.option["float"]) {
			switch(id) {
				case "siteheader":
					if (val.css.margin) {
						var m = val.css.margin.split(" "),
							winW = $(window).width(),
							headerW = winW - nopxNum(m[1]) - nopxNum(m[3]);
					}
					$(this).css({
						"position":"fixed",//横スクロールの際はテンプレート側から"static"で上書き
						"top": 0,
						"z-index":$.LiVE.zindex.sidefloatON
					});
					if (val.css.margin) {
						$(this).css({
							'width':headerW,
							"margin-top": m[0],
							"margin-bottom": m[2],
							"margin-right": m[1],
							"margin-left": m[3]
						});
					}
					break;
				case "sitefooter":
					if (val.css.margin) {
						var m = val.css.margin.split(" "),
							winW = $(window).width(),
							footerW = winW - nopxNum(m[1]) - nopxNum(m[3]);
					}
					$(this).css({
						"position":"fixed",//横スクロールの際はテンプレート側から"static"で上書き
						"bottom":0,
						"z-index":$.LiVE.zindex.sidefloatON
					});
					if (val.css.margin) {
						$(this).css({
							'width':footerW,
							"margin-top": m[0],
							"margin-bottom": m[2],
							"margin-right": m[1],
							"margin-left": m[3]
						});
					}
					break;
			}
		}
		if (val.option["float"] && val.option["push"]) {
			switch(id) {
				case "siteheader": $base.css("padding-top",$(this).height());break;
				case "sitefooter": $base.css("padding-bottom",$(this).height());break;
			}
		}
		if (val.option["float"] && val.option["autohide"]) {
			if (val.option["toppage"] && $.LiVE.body.toppage) return;
			function autohide(id,dir) {
				var pos = 0,
					scrolltop = $(window).scrollTop(),
					doch = $(document).height(),
					winh = $.LiVE.winHeight();
				switch(dir) {
					case "top":
						pos = scrolltop > 0 ? $(this).height() * -1 : 0;
						$(id).animate({
							top: pos
						},{
							duration:500,
							queue:false,
							easing:"easeOutQuint"
						});
						break;
					case "bottom":
						pos = scrolltop >= doch-winh ? 0 : $(this).height() * -1;
						$(id).animate({
							bottom: pos
						},{
							duration:500,
							queue:false,
							easing:"easeOutQuint"
						});
						break;
				}
			}
			switch(id) {
				case "siteheader":
					$(window).scroll(function() {
						autohide("#"+id,"top");
					});
					break;
				case "sitefooter":
					$(window).scroll(function() {
						autohide("#"+id,"bottom");
					});
					break;
			}
		}
		if ( $this.css('position') == 'static' ) {
			$this.width('auto');
		}
	};
	
	/********
	スライドアニメーション
	@inview
	********/
	$.fn.panelanimationset = function() {
		var $this = $(this),
			id = $this.attr("id"),
			data = $.LiVE.panel[id].data,
			speed = "slow";
		
		if (data.animation) {
			var _title = $this.find(".panel-title"),
				_description = $this.find(".panel-description");
			_title.css("opacity", 0);
			_description.css("opacity", 0);
			$this.bind("inview", function(event, isInView, visiblePartX, visiblePartY) {
				if (isInView) {
					_title.delay(500).animate({
						opacity: 1
					}, speed);
					
					// タイトルが非表示ならば、早める
					if (_title.length == 0) {
						_description.delay(500).animate({
							opacity: 1
						}, speed);
					} else {
						_description.delay(1500).animate({
							opacity: 1
						}, speed);
					}
				}
			});
		}
	};
	
	/********
	ナビゲーション制御
	@inview
	********/
	$.LiVE.navicontrol = {
		callbacks: [],
		feedback: function(sid) {
			// update current position
			$.LiVE.currentpanelorder = $.LiVE.getPanelIndex(sid);
			
			// call callback
			var len = $.LiVE.navicontrol.callbacks.length;
			for (var i=0; i<len; i++) {
				$.LiVE.navicontrol.callbacks[ i ].call(window, sid);
			}
		}
	};
	
	/********
	アプリ用
	@easing
	********/
	$.LiVE.currentpanel = {
		speed: 500,
		easing: "easeOutQuint",
		set: function(id) {
			$.LiVE.navi.jump(id);	//テンプレートごとに移動方法が変わるため、$.LiVE.navi.jump関数をグローバルに持たせました。この関数をアプリでも使ってください
			return false;
		}
	};
	$.LiVE.widgetpositioncontrol = {
		option: function(id,val) {
			$.LiVE.widget[id].option.float = val;
			$("#"+id).widgetpositionset();
		},
		set: function(id,x,y) {
			$.LiVE.widget[id].position.x[0] = x;
			$.LiVE.widget[id].position.y[0] = y;
			$("#"+id).widgetpositionset();
		},
		x: function(id,offsetx) {
			$.LiVE.widget[id].position.x[1] = offsetx;
			$("#"+id).widgetpositionset();
		},
		y: function(id,offsety) {
			$.LiVE.widget[id].position.y[1] = offsety;
			$("#"+id).widgetpositionset();
		}
	};
	$.LiVE.widgetzindexcontrol = {
		set: function(id,val) {
			$.LiVE.widget[id].z = val;
			$("#"+id).widgetzindexset();
		}
	};
	$.LiVE.widgetedit = function(id) {
		AirEngineMethod_OnEdit( id, $.LiVE.widget[id] );
	};
	$.LiVE.widgetdelete = function(id) {
		AirEngineMethod_OnDelete( id );
	};
	
	
	/********
	パネルサウンド
	サウンドエフェクト
	@jquery
	@soundmanager
	$.LiVE.sound.dataに以下の値を追加
		[3]: soundID
		[4]: soundData
		[5]: playstatus
	********/
	$.LiVE.panelsound = {
		threshold: 400,
		sevolume: 20,
		bgmvolume: new Object(),
		vscroll: ($.LiVE.body.scroll == "vertical"),
		useSound: false,
		inview: function(id) {
			var $panel = $("#" + id),
				$window = $(window);
			if (this.vscroll) return $panel.css("display") == "block" && $window.scrollTop() >= ($panel.offset().top-this.threshold) && $window.scrollTop() <= ($panel.offset().top+$panel.height());
			else {
				var w = $window.width();
				//return (w / 2 * -1 <= $panel.offset().left && $panel.offset().left < w / 2);
				return (w * -1 <= $panel.offset().left && $panel.offset().left < w);
			}
		},
		volume: function(id) {
			var $panel = $("#" + id),
				volume = $.LiVE.panelsound.bgmvolume[id],
				$window = $(window);
			
			if (this.vscroll) {
				if ($window.scrollTop() < $panel.offset().top) {
					return Math.ceil(volume - ($panel.offset().top - $window.scrollTop()) / $.LiVE.panelsound.threshold * volume);
				}
				else if ($window.scrollTop() > $panel.offset().top+$panel.height()-this.threshold) {
					return Math.ceil(($panel.offset().top + $panel.height() - $window.scrollTop()) / $.LiVE.panelsound.threshold * volume);
				}
				else return volume;
			} else {
				//var threshold = $window.width() / 2;
				var threshold = $window.width();
				return volume * (1 - (1 / threshold * Math.abs($panel.offset().left)));
			}
		},
		attach: function(data) {
			var control = function() {
					if ($.LiVE.panelsound.inview(data[0])) {
						soundManager.setVolume(data[3], $.LiVE.panelsound.volume(data[0]));
						soundManager.play(data[3]);
						data[5] = true;
					}
					else {
						soundManager.pause(data[3]);
						data[5] = false;
					}
				};
			return control;
		},
		set: function() {
			// check
			if ($.LiVE.body.se.over[0] || $.LiVE.body.se.click[0]) {
				$.LiVE.panelsound.useSound = true;
			} else {
				for (var i=0; i<$.LiVE.sound.data.length; i++) {
					var s = $.LiVE.sound.data[i];
					if (s[1].length > 0) {
						$.LiVE.panelsound.useSound = true;
						break;
					}
				}
			}
			
			if ($.LiVE.panelsound.useSound == false) return;
			
			// set sound manager
			$.lazyLoad('core/common/js/plugin/soundmanager/soundmanager2-nodebug-jsmin.js')
				.done(function(scr, status) {
					$.LiVE.panelsound.init();
				});
			
		},
		init: function() {
			window.soundManager = new SoundManager();
			soundManager.url = "core/common/js/plugin/soundmanager/";
			soundManager.flashVersion = 9;
			soundManager.useFlashBlock = false;
			soundManager.preferFlash = false;
			soundManager.beginDelayedInit();
			
			soundManager.onready(function() {
				//BGM
				for (var i=0; i<$.LiVE.sound.data.length; i++) {
					var sound = $.LiVE.sound.data[i];
					sound[3] = "bgm_" + sound[0];
					sound[4] = soundManager.createSound({
						id: sound[3],
						url: sound[1],
						autoLoad: true,
						multiShot: false,
						loops: 100
					});
					sound[5] = false;
					$.LiVE.panelsound.bgmvolume[sound[0]] = sound[2];
					
					if (sound[0]=="page") {
						soundManager.play(sound[3]);
						soundManager.setVolume(sound[3], Math.ceil(sound[2]));
						sound[5] = true;
					}
					else if ($.LiVE.panelsound.vscroll) $(window).bind("scroll", $.LiVE.panelsound.attach(sound));
					else $("#contents").bind("scroll", $.LiVE.panelsound.attach(sound));
				}
				
				// SE
				var seOver = soundManager.createSound({
						id: "se_over",
						url: $.LiVE.body.se.over[1],
						autoLoad: true,
						multiShot: true
					}),
					seClick = soundManager.createSound({
						id: "se_click",
						url: $.LiVE.body.se.click[1],
						autoLoad: true,
						multiShot: true
					}),
					sePlay = {
						over: function() {
							soundManager.setVolume("se_over", $.LiVE.panelsound.sevolume);
							soundManager.play("se_over");
						},
						click: function() {
							soundManager.setVolume("se_click", $.LiVE.panelsound.sevolume);
							soundManager.play("se_click");
						}
					};
				
				$.LiVE.sesound = sePlay;
				
				if ($.LiVE.body.se.over[0]) {
					$("a").live("mouseover", sePlay.over);
				}
				if ($.LiVE.body.se.click[0]) {
					$("a").live("click", sePlay.click);
				}
				
			});
		},
		mute: function(sw) {
			if (typeof(soundManager) == 'undefined') return;
			if (sw) soundManager.mute();
			else soundManager.unmute();
		}
	};
	
	/********
	ブラウザ判断
	IE用 メディアクエリ未実装対応、filter適用
	********/
	$.LiVE.browser = {
		name: "undefined",
		check: function() {
			if (userAgent.indexOf("opera")>-1) this.name = "opera";
			else if (userAgent.indexOf("msie")>-1) {
				this.name = "ie";
				if (appVersion.indexOf("msie 8")>-1) this.name = "ie8";
				if (appVersion.indexOf("msie 9")>-1) this.name = "ie9";
				this.ie();
			}
			else this.name = "else";
		},
		ie: function() {
			$("head").find("link[data-css='mobile']").remove();
		}
	};
	$.LiVE.browser.check();	//すぐに実行
	
	/********
	キーボードアサイン
	@jquery
	********/
	$.fn.Keyboard = function(settings) {
		
		var config = {};
		if (settings) $.extend(config, settings);
		
		this.each(function() {
			var $this = $(this),
				$body = $("body");
			
			$(document).bind("keydown", on_keydown);
			
			function on_keydown(e) {
				var key = e.charCode ? e.charCode : e.keyCode ? e.keyCode : 0;
				
				switch(key) {
					
					case 13:	//enter
						$body.triggerHandler($.LiVE.Events.KEY_ENTER);
						break;
						
					case 27:
						$body.triggerHandler($.LiVE.Events.KEY_ESC);
						break;
						
					case 32:
						$body.triggerHandler($.LiVE.Events.KEY_SPACE);
						break;
						
					case 38:
						$body.triggerHandler($.LiVE.Events.KEY_UP);
						break;
						
					case 39:
						$body.triggerHandler($.LiVE.Events.KEY_RIGHT);
						break;
						
					case 40:
						$body.triggerHandler($.LiVE.Events.KEY_DOWN);
						break;
						
					case 37:
						$body.triggerHandler($.LiVE.Events.KEY_LEFT);
						break;
				}
			}
		});
		
		return this;
	};
	
	/********
	日付ユーティリティ
	********/
	$.LiVE.dateutil = {
		isLeapYear: function(d) {
			return new Date(d.getFullYear(), 1, 29).getDate() == 29;
		},
		maxDays: function(d) {
			switch (d.getMonth())
			{
				case 3:
				case 5:
				case 8:
				case 10:
					return 30;
				case 1:
					return this.isLeapYear(d) ? 29 : 28;
				default:
					return 31;
			}
		}
	};
	
	/********
	ユーティリティ
	********/
	$.LiVE.util = {
		getEmbedProtocol: function() {
			var prtcl = location.protocol;
			if (prtcl == "file:") prtcl = "http:";
			return prtcl;
		},
		getNumber: function(src) {
			if (src == 'auto' || typeof(src) == 'undefined') return 0;
			src = src.replace("px");
			src = src.replace("%");
			return parseInt(src);
		},
		getVideoId: function(url) {
			// get videoid for YouTube or Vimeo.
			var videoid = url.match(/[a-z,0-9,\-,=,&,_,#,!]+$/i).toString();
			if (videoid.match(/=/)) {
				var ary = videoid.split("&");
				for (var i=0; i<ary.length; i++) {
					if (ary[i].indexOf("v=")==0) {
						videoid = ary[i].substring(2);
						break;
					}
				}
			}
			return videoid;
		},
		unescapeEntity: function(src) {
			src  = src.replace(/&amp;/g, "&");
			src = src.replace(/&gt;/g, ">");
			src = src.replace(/&lt;/g, "<");
			src = src.replace(/&quot;/g, "\"");
			src = src.replace(/&#165;/g, "\\");
			return src;
		},
		splitCSS: function(src) {
			if (typeof(src) == "undefined") return {top:0, right:0, bottom:0, left:0};
			
			var ary = src.split(" ");
			return {
				top: $.LiVE.util.getNumber(ary[0]),
				right: $.LiVE.util.getNumber(ary[1]),
				bottom: $.LiVE.util.getNumber(ary[2]),
				left: $.LiVE.util.getNumber(ary[3])
			};
		},
		formatLink: function(src) {
			src = src.replace(/((ftp|https?):\/\/([-\w\.]+)+(:\d+)?(\/([\w/_\.]*(\?\S+)?)?)?)/gm,'<a href="$1" target="_blank">$1</a>');
			return src;
		},
		zeroPad: function(src, total) {
			var buf = new String(src);
			var len = buf.length;
			for (var i=len; i<total; i++) {
				buf = "0" + buf;
			}
			return buf;
		}
	};
	
	/********
	パネルセット関数
	ロード順の関係上、各パネルテンプレートJSで実行
	********/
	$.LiVE.panelstyle = {
		settings: {},	//幅・高さ設定
		func: {},		//各パネルごとの関数
		set: function() {
			$.LiVE.Elements.PANELS.all.each(function(i) {
				var panel = $(this);
				
				panel.panelbgset();
				panel.panelsizeadjust($.LiVE.panelstyle.settings);
				panel.tilepositionset();
				panel.paneloptioncssset();
				
				if ($.LiVE.mobile.check) {
					//panel.mobile_normalize();
					panel.find("span").each(function() {
						// 明朝をiPhone向けに
						var fname = this.style.fontFamily;
						if (fname.indexOf("'hiragino mincho pro'") > -1) {
							fname = fname.replace('hiragino mincho pro', 'hiragino mincho pron');
							this.style.fontFamily = fname;
						}
					});
					
				} else {
					panel.panelanimationset();
				}
				
				$.LiVE.panelstyle.func(panel, i);
			});
		}
	};
	
	function setSideFloatOption() {
		if ($.LiVE.body.scroll=="") {	//横スクロールの場合 サイトヘッダ・サイトフッタ強制フロート解除
			if ($.LiVE.Elements.SIDES.siteheader.length > 0) {
				$.LiVE.side.siteheader.option.autohide = false;
			}
			if ($.LiVE.Elements.SIDES.sitefooter.length > 0) {
				$.LiVE.side.sitefooter.option.autohide = false;
			}
		}
	}
	
	// ページ内リンクのスクロール設定
	function setScrollTo() {
		var ary = location.pathname.split("/");
		var fname = ary[ary.length-1];
		if (fname.length == 0) fname = "index.html";
		
		$("a").each(function(i, e) {
			$this = $(e);
			var href = $(e).attr("href");
			if (typeof(href) != 'undefined' && href.indexOf(fname + "#") == 0) {
				$this.click(function() {
					$.LiVE.navi.jump(href.match(/id[0-9]+/));
				});
			}
		});
	}

	function optimizeMobile() {
		var $panels = $.LiVE.Elements.PANELS.all;
		if ($panels.length > 0) {
			// 全てのウィンドウ固定ウィジェットをトップスライドに固定
			var topId = $panels[ 0 ].id;
			for (var key in $.LiVE.widget) {
				var widget = $.LiVE.widget[ key ];
				if ($.LiVE.body.scroll == "" && widget.type == "navi") {
				} else {
					if (widget.option.float) {
						widget.option.float = false;
						widget.option.fixedTo = topId;
					}
				}
			}
			
			// tile調整
			for (var key in $.LiVE.panel) {
				var panel = $.LiVE.panel[ key ],
					tileW = panel.tilecss.width,
					deviceW = $(window).width();

				if ( tileW ) {
					// %をpxに変換する
					if (tileW.indexOf('%')>-1) {
						tileW = $.LiVE.util.getNumber( tileW );
						var parsent = tileW * 0.01;
						tileW = deviceW * parsent + 'px';
					}
					var	w = $.LiVE.util.getNumber( tileW );
					if ( w >= deviceW ) w = deviceW;
					panel.tilecss.width = w + "px";
				}
			}
		}
		// サイトヘッダー＆フッターのフロート解除
		$.LiVE.side['siteheader'].option.float = false;
		$.LiVE.side['sitefooter'].option.float = false;
	}
	
	//モバイルの際、イメージ画像が各コンテンツの表示領域より大きければ横を強制的に最大幅まで縮小する
	function mobileImgResized() {
		var $panel = $.LiVE.Elements.PANELS.all;
		
		$panel.each( function() {
			var $plate = $(this).find('header.plate'),
				plateh1 = $plate.find('h1.panel-title'),
				plateh1W = plateh1.outerWidth(true),
				plateDesc = $plate.find('div.panel-description'),
				plateDescW = plateDesc.outerWidth(true);
			plateh1.find("img").each(function() {
				var imgW = $(this).width();
				if ( imgW > plateh1W ) {
					$(this).css('width','100%');
				}
			});
			plateDesc.find("img").each(function() {
				var imgW = $(this).width();
				if ( imgW > plateDescW ) {
					$(this).css('width','100%');
				}
			});
		});
	}

	function optimizeMobileTileSize() {
		if ($.LiVE.body.scroll == "vertical") {
			var winW = $.LiVE.winHeight();
			$.LiVE.Elements.PANELS.all.each(function(){
				var $sec = $(this),
					$box = $sec.find(">.box"),
					$blk = $box.find(".block");
				$box.css("width", "auto");
				
				var originalH = $blk.height();
				var contH = $blk[0].scrollHeight;
				if (contH > originalH) {
					//$blk.css("height", "auto");
					$blk.css("height", contH + "px");
					if ($blk.height()==0) $blk.height(originalH);
				}
				
				// 幅があふれたら納める
				if ($blk.outerWidth(true) + $.LiVE.util.getNumber($blk.css("left")) > winW) {
					$blk.css("width", "auto");
				}
				
				// 高さをコンテンツのイキママに
				var _h = $blk.outerHeight(true);
				_h += $.LiVE.util.getNumber($blk.css("top"));
				$box.css("height", _h);
			});
			$.LiVE.Elements.PANELS.all.css("overflow", "hidden");
		} else {
			// 横スクロール
			$.LiVE.Elements.PANELS.all.css("overflow-x", "hidden");
			$.LiVE.Elements.PANELS.all.find(".block").css("overflow", "auto");
		}
	}
	
	function hideMobileAddressBar() {
		if (window.pageYOffset === 0) window.scrollTo(0, 1);
	}
	
	function showMobileGuide() {
		if ($.cookie("lv:showMobileGuide") != "true") {
			var attention = $("<img>")
					$win = $(window);
			attention.attr("src", "core/common/css/mobile-navi_" + $.LiVE.mobile.type + ".png");
			attention.load(function(){
				var w = attention.width(),
					h = attention.height();
				if ($.LiVE.mobile.type != 'ipad') {
					w = w * 2;
					h = h * 2;
				}
				
				attention.css({
					position: "fixed",
					width: w, height: h,
					left: ($win.width() - w) / 2,
					top: ($.LiVE.winHeight() - h) / 2,
					cursor: "pointer",
					zIndex: 9999
				});
				
				var hideMe = function() {
					attention.stop().fadeOut("fast", function(){
						attention.remove();
					});
				};
				
				attention.click(hideMe);
				setTimeout(hideMe, 5000);
			
			});
			attention.appendTo(document.body);
			
			$.cookie("lv:showMobileGuide", "true");
		}
	}
	
	/********
	■関数実行
	追加指定設定：
		幅・マージンはパネルの一番外側に適用
		ボーダーはひとつ中の「box」に適用
		背景レイヤーは一番外側とその中の「box」に、それぞれ適用
	********/
	var $window = $.LiVE.Elements.WINDOW,
		$body = $("body"),
		$side = $.LiVE.Elements.SIDES.all,
		$sitemenu = $.LiVE.Elements.SIDES.sitemenu,
		$panels = $.LiVE.Elements.PANELS.all,
		$widgets = $.LiVE.Elements.WIDGETS.all,
		$siteheader = $.LiVE.Elements.SIDES.siteheader,
		loadFlag = false;

	$.LiVE.mobile.ua();
	$.LiVE.mode.check();
	if ($.LiVE.loading && $.LiVE.loading.activate) $.LiVE.loading.set();
	if ($.LiVE.opening && $.LiVE.opening.activate) $.LiVE.opening.set();
	
	// 縦メニューの判定フラグセット
	var box = $.LiVE.Elements.SIDES.siteheader.find(".box");
	$.LiVE.Elements.SIDES.siteheader.isVertical = (box.length > 0 && box[0].className.indexOf("vertical") > -1);
	
	// mobile時のJSON値置換
	if ($.LiVE.mobile.check) optimizeMobile();
	
	$body.bodybgset();
	$body.Keyboard();
	$body.hidePageScroller();
	
	$panels.imgalign();
	
	setSideFloatOption();
	$side.each(function() {
		$(this).sidebgset();
		$(this).sideoptioncssset();
		$(this).sidepositionset();
		$(this).sidecolumnwidthset();
		$(this).sidefloatset();
		$(this).verticalcssset();
	});
	$sitemenu.menubgset();
	$sitemenu.menuoptioncssset();
	$siteheader.headercssset();
	
	$widgets.each(function() {
		var widget = $(this);
		if ($.LiVE.mobile.check && $.LiVE.body.scroll == "vertical" && widget.hasClass("navi")) {
			widget.remove();
		} else {
			widget.widgetbgset();
			widget.widgetoptioncssset();
			widget.widgetzindexset();
			widget.widgetpositionset();
		}
	});

	setScrollTo();
	
	if ($.LiVE.mode.edit.activate) {
		$.LiVE.mode.edit.off_animation();
	} else if ($.LiVE.mode.name != "capture" && $.LiVE.mobile.check == false) {
		$.LiVE.panelsound.set();
	}
	
	$(window).load(function(){
		if (loadFlag) return;
		loadFlag = true;
		$("body,#siteheader,#sitefooter,#pageheader,#pagefooter,#main,#widget").css("visibility","visible");
		
		//スライドアニメーション用
		setTimeout(function() {$(this).trigger("scroll");}, 1000);
		
		//ウィジェットポジション用
		if ($.LiVE.mobile.check) {
			$(this).trigger("orientationchange");
		} else {
			$(this).resize();
		}
		
		// パネルサウンド（横スライド時）
		if ($.LiVE.body.scroll == "") setTimeout(function() {$("#contents").scroll();}, 1000);

		//プレゼンテーションモードの場合で、オープニング動画が設定されていなければ即時で画面をスライドさせる
		if ( $.LiVE.mode.presentation.activate && !$.LiVE.body.opening.activate ) $.LiVE.mode.presentation.main();
		
		// mobile時
		if ($.LiVE.mobile.check) {
			// show mobile guide
			showMobileGuide();
		}
		
		// エディター枠表示
		if ($.LiVE.mode.edit.activate) var tm = setTimeout(function() {$.LiVE.mode.edit.set(); clearTimeout(tm); }, 400);
	});

	//loadに発火してない時用の処理
	setTimeout( function() {
		if ( loadFlag == false ) {
			$(window).load();
		}
	},5000);

});

