<?php
require './src/facebook.php';

$facebook = new Facebook(array(
  'appId'  => '***************',
  'secret' => '********************************',
));

$user = $facebook->getUser();
?>

<!doctype html>
<html xmlns:fb="http://www.facebook.com/2008/fbml">
  <head>
    <meta charset="utf-8" />
    <title>Gender ratio</title>
  </head>
  <body>
    <div id="fb-root"></div>
    <script>
      window.fbAsyncInit = function() {
        FB.init({
          appId: '<?php echo $facebook->getAppID() ?>',
          cookie: true,
          xfbml: true,
          oauth: true
        });
        FB.Event.subscribe('auth.login', function(response) {
          window.location.reload();
        });
        FB.Event.subscribe('auth.logout', function(response) {
          window.location.reload();
        });
      };
      (function() {
        var e = document.createElement('script'); e.async = true;
        e.src = document.location.protocol +
          '//connect.facebook.net/en_US/all.js';
        document.getElementById('fb-root').appendChild(e);
      }());
      
      function post_result(message) {
        FB.ui(
          {
            method: 'feed',
            name: 'Gender Ratio',
            link: 'http://apps.facebook.com/gen_ratio/',
            caption: 'Gender Ratio',
            description: message
          },
          function(response) {
            if (response && response.post_id) {
              alert('posted!');
            }
          }
        );
        return false;
      }
    </script>

    <h1>Gender ratio</h1>

<?php
if (!$user) {
    $loginUrl = $facebook->getLoginUrl(array(
        'canvas' => 1,
        'fbconnect' => 0,
        'scope' => 'publish_stream'
    ));
    echo "<div>";
    echo "<a href=\"" . $loginUrl . "\" target=\"_top\">Login!!</a>";
    echo "</div>";
} else {
    $friends = $facebook->api('me/friends');
    $ids = "";
    $userdata = $friends['data'];

    foreach ($userdata as $u) {
        $ids .= "," . $u['id'];
    }
    $param = array(
        'method' => 'users.getinfo',
        'uids' => substr($ids, 1),
        'fields' => 'sex'
    );

    $data = $facebook->api($param);

    $m = 0; $f = 0;
    $c = 0;
    foreach ($data as $i) {
        if ($i['sex'] == "male") {
            $m++;
        } elseif ($i['sex'] == "female") {
            $f++;
        }
        $c++;
    }

    $mp = round($m / $c * 100);
    $fp = round($f / $c * 100);
    $np = 100 - ($mp + $fp);

    $charturl = "https://chart.googleapis.com/chart?cht=p&chs=450x225&chd=t:$mp,$fp,$np&chl=male($mp%)|female($fp%)|etc($np%)";

    echo "<div><img src='" . $charturl . "' /></div>";

    $message = "male($mp%) female($fp%) etc($np%)";

    echo "<div><a href=\"#\" onclick=\"return post_result('$message');\">Post!</a></div>";
}
?>
  </body>
</html>
