package jp.sf.amateras.wtp.validation;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.validation.internal.core.Message;
import org.eclipse.wst.validation.internal.core.ValidationException;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidationContext;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class StrutsConfigValidator implements IValidator {
	
	public void cleanup(IReporter reporter) {
		// Ȃ
	}

	public void validate(IValidationContext helper, IReporter reporter) throws ValidationException {
		
		String[] uris = helper.getURIs();
		reporter.removeAllMessages(this);
		
		if (uris != null) {
			for (int i = 0; i < uris.length && !reporter.isCancelled(); i++) {
				IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(new Path(uris[i]));
				IStructuredModel model = null;
				try {
					// SSEf擾
					model = StructuredModelManager.getModelManager().getModelForRead(file);
					
					IDOMModel domModel = (IDOMModel)model;
					IDOMDocument doc = domModel.getDocument();
					IDOMElement element = (IDOMElement)doc.getDocumentElement();
					
					validateElement(element, file, reporter);
				
				} catch(Exception ex){
					ex.printStackTrace();
				} finally {
					if(model != null){
						model.releaseFromRead();
					}
				}
			}
		}
	}
	
	private void validateElement(IDOMElement element, IFile file, IReporter reporter){
		
		NamedNodeMap attrs = element.getAttributes();
		
		for(int i=0;i<attrs.getLength();i++){
			IDOMAttr attr = (IDOMAttr)attrs.item(i);
			// "type"̏ꍇ̂
			if(attr.getName().equals("type")){
				String className = attr.getValue().trim();
				try {
					// NX݂邩ǂ`FbN
					IJavaProject project = JavaCore.create(file.getProject());
					IType type = project.findType(className);
					if(type==null || !type.exists()){
						// G[bZ[W쐬
						int startOffset = element.getStartOffset();
						ITextRegion region = attr.getValueRegion();
						
						startOffset = startOffset + region.getStart();
						int length = region.getLength();
						
						Message message = new Message();
						message.setSeverity(IMessage.NORMAL_SEVERITY);
						message.setOffset(startOffset);
						message.setLength(length);
						message.setBundleName("jp.sf.amateras.wtp.validation.messages");
						message.setId("not.exist");
						message.setParams(new String[]{ className });
						message.setTargetObject(file);
						
						// bZ[Wǉ
						reporter.addMessage(this, message);
					}
				} catch(JavaModelException ex){
					ex.printStackTrace();
				}
			}
		}
		// qvfċAIɏ
		NodeList children = element.getChildNodes();
		for(int i=0;i<children.getLength();i++){
			Node child = children.item(i);
			if(child instanceof IDOMElement){
				validateElement((IDOMElement)child, file, reporter);
			}
		}
	}
}
