package jp.sf.amateras.wtp.facet;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jst.j2ee.web.componentcore.util.WebArtifactEdit;

public class StrutsFacetUtils {
	
	public static String[] STRUTS_JARS = {
	    "antlr-2.7.2.jar",
	    "commons-beanutils-1.7.0.jar",
	    "commons-chain-1.1.jar",
	    "commons-digester-1.8.jar",
	    "commons-logging-1.0.4.jar",
	    "commons-validator-1.3.1.jar",
	    "oro-2.0.8.jar",
	    "struts-core-1.3.8.jar",
	    "struts-taglib-1.3.8.jar",
	    "struts-tiles-1.3.8.jar"
	};
	
	/** WEB-INFtH_̃pX擾 */
	public static IPath getWebInfPath(IProject project) {
		WebArtifactEdit web = null;
		try {
			web = WebArtifactEdit.getWebArtifactEditForRead(project);
			IPath webxml = web.getDeploymentDescriptorPath();
			return webxml.removeLastSegments(1).removeFirstSegments(1);
		} finally {
			if (web != null) {
				web.dispose();
			}
		}
	}	

}
