package jp.sf.amateras.wtp.facet;

import java.io.File;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.j2ee.web.componentcore.util.WebArtifactEdit;
import org.eclipse.jst.j2ee.webapplication.Servlet;
import org.eclipse.jst.j2ee.webapplication.ServletMapping;
import org.eclipse.jst.j2ee.webapplication.ServletType;
import org.eclipse.jst.j2ee.webapplication.WebApp;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.project.facet.core.IDelegate;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;

public class StrutsFacetUninstallDelegate implements IDelegate {

	public void execute(IProject project, IProjectFacetVersion fv, Object config, IProgressMonitor monitor) throws CoreException {
		if (monitor != null) {
			monitor.beginTask("Remove Struts JARs", StrutsFacetUtils.STRUTS_JARS.length + 1);
		}
		try {
			IDataModel dataModel = null;
			if (config != null) {
				dataModel = (IDataModel) config;
			}
			// JARt@CQWEB-INF/lib폜
			removeJarFiles(project, dataModel, monitor);
			// web.xmlXV
			modifyWebXML(project, monitor);
			// vWFNgtbV
			project.refreshLocal(IProject.DEPTH_INFINITE, monitor);
			
		} finally {
			if (monitor != null) {
				monitor.done();
			}
		}
	}
	
	/** StrutsJARt@CWEB-INF/lib폜 */
	private void removeJarFiles(IProject project, IDataModel config, IProgressMonitor monitor) {
		// WEB-INFtH_̃pX擾
		IPath destPath = project.getLocation().append(StrutsFacetUtils.getWebInfPath(project));
		File webInf = destPath.toFile();
		// JARt@C̐[vȂ폜
		for(int i=0;i<StrutsFacetUtils.STRUTS_JARS.length;i++){
			try {
				File file = new File(webInf, "lib/" + StrutsFacetUtils.STRUTS_JARS[i]);
			
				if(file.exists()){
					file.delete();
				} else {
					continue;
				}
			} catch(Exception ex){
				ex.printStackTrace();
			} finally {
				// vOXj^i߂
				if (monitor != null) {
					monitor.worked(1);
				}
			}
		}
	}
	
	private void modifyWebXML(IProject project, IProgressMonitor monitor){
		WebArtifactEdit artifactEdit = null;
		try {
			artifactEdit = WebArtifactEdit.getWebArtifactEditForWrite(project);
			WebApp webApp = artifactEdit.getWebApp();
			
			// ANVT[ubgURL}bsO폜
			EList servlets = webApp.getServlets();
			for(int i=0;i<servlets.size();i++){
				Servlet servlet = (Servlet)servlets.get(i);
				ServletType servletType = (ServletType)servlet.getWebType();
				if(servletType.getClassName().equals("org.apache.struts.action.ActionServlet")){
					ServletMapping mapping = webApp.getServletMapping(servlet);
					webApp.getServletMappings().remove(mapping);
					servlets.remove(servlet);
					break;
				}
			}
			
			artifactEdit.saveIfNecessary(monitor);
			
		} finally {
			if(artifactEdit!=null){
				artifactEdit.dispose();
			}
			if(monitor!=null){
				monitor.worked(1);
			}
		}
	}


}
