package jp.sf.amateras.wtp.facet;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;

import jp.sf.amateras.wtp.Activator;

import org.apache.commons.io.IOUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jst.j2ee.web.componentcore.util.WebArtifactEdit;
import org.eclipse.jst.j2ee.webapplication.Servlet;
import org.eclipse.jst.j2ee.webapplication.ServletMapping;
import org.eclipse.jst.j2ee.webapplication.ServletType;
import org.eclipse.jst.j2ee.webapplication.WebApp;
import org.eclipse.jst.j2ee.webapplication.WebapplicationFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.project.facet.core.IDelegate;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;

public class StrutsFacetInstallDelegate implements IDelegate {
	
	public void execute(IProject project, IProjectFacetVersion fv, Object config, IProgressMonitor monitor) throws CoreException {
		if (monitor != null) {
			monitor.beginTask("Copy Struts JARs", StrutsFacetUtils.STRUTS_JARS.length + 1);
		}
		try {
			IDataModel dataModel = null;
			if (config != null) {
				dataModel = (IDataModel) config;
			}
			// JARt@CQWEB-INF/libɃRs[
			copyJarFiles(project, dataModel, monitor);
			// web.xmlXV
			modifyWebXML(project, monitor);
			// vWFNgtbV
			project.refreshLocal(IProject.DEPTH_INFINITE, monitor);
			
		} finally {
			if (monitor != null) {
				monitor.done();
			}
		}
	}
	
	/** StrutsJARt@CWEB-INF/libɃRs[ */
	private void copyJarFiles(IProject project, IDataModel config, IProgressMonitor monitor) {
		// WEB-INFtH_̃pX擾
		IPath destPath = project.getLocation().append(StrutsFacetUtils.getWebInfPath(project));
		File webInf = destPath.toFile();
		// JARt@C̐[vȂRs[
		for(int i=0;i<StrutsFacetUtils.STRUTS_JARS.length;i++){
			InputStream in = null;
			OutputStream out = null;
			try {
				File file = new File(webInf, "lib/" + StrutsFacetUtils.STRUTS_JARS[i]);
				if(!file.exists()){
					file.createNewFile();
				} else {
					continue;
				}
				
				URL url = Activator.getDefault().getBundle().getEntry("struts-1.3.8/lib/" + StrutsFacetUtils.STRUTS_JARS[i]);
				in = url.openStream();
				out = new FileOutputStream(file);
				
				IOUtils.copy(in, out);
				
			} catch(Exception ex){
				ex.printStackTrace();
			} finally {
				IOUtils.closeQuietly(in);
				IOUtils.closeQuietly(out);
				// vOXj^i߂
				if (monitor != null) {
					monitor.worked(1);
				}
			}
		}
	}
	
	private void modifyWebXML(IProject project, IProgressMonitor monitor){
		WebArtifactEdit artifactEdit = null;
		try {
			artifactEdit = WebArtifactEdit.getWebArtifactEditForWrite(project);
			WebApp webApp = artifactEdit.getWebApp();
			
			// ANVT[ubgǉ
			Servlet servlet = WebapplicationFactory.eINSTANCE.createServlet();
			servlet.setServletName("action");

			ServletType servletType = WebapplicationFactory.eINSTANCE.createServletType();
			servletType.setClassName("org.apache.struts.action.ActionServlet");
			servlet.setWebType(servletType);
			servlet.setLoadOnStartup(new Integer(1));
			webApp.getServlets().add(servlet);
			
			// URL}bsOǉ
			ServletMapping mapping = WebapplicationFactory.eINSTANCE.createServletMapping();
			mapping.setServlet(servlet);
			mapping.setName(servlet.getServletName());
			mapping.setUrlPattern("*.do");
			webApp.getServletMappings().add(mapping);
			
			artifactEdit.saveIfNecessary(monitor);
			
		} finally {
			if(artifactEdit!=null){
				artifactEdit.dispose();
			}
			if(monitor!=null){
				monitor.worked(1);
			}
		}
	}

}
