package jp.sf.amateras.wtp.editor;

import jp.sf.amateras.wtp.Activator;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.wst.xml.ui.views.contentoutline.XMLContentOutlineConfiguration;

public class StrutsConfigOutlineConfiguration extends XMLContentOutlineConfiguration {

	private ILabelProvider labelProvider = null;
	
	private IAction action = new Action("AEgCr[̃ANV", 
			Activator.getImageDescriptor("icons/action.gif")){
		public void run(){
			// ANV̏
		}
	};
	
	public ILabelProvider getLabelProvider(TreeViewer viewer) {
		if(labelProvider==null){
			labelProvider = new StrutsOutlineLabelProvider();
		}
		return labelProvider;
	}

	protected IContributionItem[] createMenuContributions(TreeViewer viewer) {
		IContributionItem[] items = super.createMenuContributions(viewer);
		
		IContributionItem[] newItems = new IContributionItem[items.length + 1];
		System.arraycopy(items, 0, newItems, 0, items.length);
		newItems[newItems.length - 1] = new ActionContributionItem(action);
		
		return newItems;
	}

	protected IContributionItem[] createToolbarContributions(TreeViewer viewer) {
		IContributionItem[] items = super.createToolbarContributions(viewer);
		
		IContributionItem[] newItems = new IContributionItem[items.length + 1];
		System.arraycopy(items, 0, newItems, 0, items.length);
		newItems[newItems.length - 1] = new ActionContributionItem(action);
		
		return newItems;
	}

}
