package jp.sf.amateras.swt.widget.all;

import org.eclipse.swt.SWT;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.custom.CBanner;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.CoolBar;
import org.eclipse.swt.widgets.CoolItem;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.ExpandBar;
import org.eclipse.swt.widgets.ExpandItem;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Slider;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class Sample {
	public static void main(String[] args) {
		// DisplayIuWFNg܂
		Display display = new Display();
		// ShellIuWFNg܂B
		final Shell shell = new Shell(display);
		shell.setText("SWT̃Tv");
		shell.setBounds(100, 100, 800, 600);
		RowLayout layout = new RowLayout();
		layout.marginHeight = 10;
		layout.marginWidth = 10;
		layout.spacing = 10;
		shell.setLayout(layout);

		// Image
		Image image = new Image(display, Sample.class.getResourceAsStream("sample.gif"));
		// Color
		Color red = new Color(display, 255, 0, 0);
		// Font
		Font font = new Font(display, "lr ", 11, SWT.ITALIC);

		// Button
		Composite buttonComposite = new Composite(shell, SWT.NONE);
		Button button = new Button(buttonComposite, SWT.PUSH);
		button.setText("Button");
		button.setSize(100, 20);
		button.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				Shell subWindow = new Shell(shell, SWT.PRIMARY_MODAL | SWT.TITLE | SWT.CLOSE
						| SWT.MIN | SWT.MAX);
				subWindow.setText("Shell");
				subWindow.setSize(200, 80);
				subWindow.open();
			}
		});
		// Label
		Composite labelComposite = new Composite(shell, SWT.NONE);
		Label label = new Label(labelComposite, SWT.BORDER);
		label.setText("Label");
		label.setSize(100, 20);
		// CLabel
		Composite clabelComposite = new Composite(shell, SWT.NONE);
		CLabel clabel = new CLabel(clabelComposite, SWT.BORDER);
		clabel.setText("CLabel");
		clabel.setImage(image);
		clabel.setSize(100, 20);
		// Link
		Composite linkComposite = new Composite(shell, SWT.NONE);
		Link link = new Link(linkComposite, SWT.BORDER);
		link.setText("Link <A>Link</A> Link");
		link.setSize(100, 20);
		// ProgressBar
		Composite progressBarComposite = new Composite(shell, SWT.NONE);
		ProgressBar progressBar = new ProgressBar(progressBarComposite, SWT.BORDER);
		progressBar.setSelection(50);
		progressBar.setSize(100, 20);
		// Scale
		Composite scaleComposite = new Composite(shell, SWT.NONE);
		Scale scale = new Scale(scaleComposite, SWT.BORDER);
		scale.setSelection(50);
		scale.setSize(150, 45);
		// Browser
		Composite browserComposite = new Composite(shell, SWT.NONE);
		Browser browser = new Browser(browserComposite, SWT.BORDER);
		//browser.setUrl("http://amateras.sourceforge.jp/cgi-bin/fswiki/wiki.cgi"
		// );
		browser.setUrl("http://www.google.co.jp");
		browser.setSize(310, 240);
		// DateTime
		DateTime datetime = new DateTime(shell, SWT.CALENDAR);
		datetime.setSize(200, 100);
		// Canvas
		Composite canvasComposite = new Composite(shell, SWT.NONE);
		Canvas canvas = new Canvas(canvasComposite, SWT.BORDER);
		canvas.setBackground(red);
		canvas.setSize(100, 50);
		// CBanner
		Composite cbannerComposite = new Composite(shell, SWT.NONE);
		CBanner cbanner = new CBanner(cbannerComposite, SWT.NONE);
		Label cbannerLabelLeft = new Label(cbanner, SWT.NONE);
		cbannerLabelLeft.setText("CBanner");
		cbanner.setLeft(cbannerLabelLeft);
		Label cbannerLabelRight = new Label(cbanner, SWT.NONE);
		cbannerLabelRight.setText("CBanner");
		cbanner.setRight(cbannerLabelRight);
		cbanner.setSimple(false);
		cbanner.setSize(150, 20);
		// Table
		Composite tableComposite = new Composite(shell, SWT.NONE);
		Table table = new Table(tableComposite, SWT.BORDER);
		table.setLinesVisible(true);
		table.setHeaderVisible(true);
		TableColumn column1 = new TableColumn(table, SWT.NONE);
		column1.setText("Table");
		column1.setWidth(80);
		TableColumn column2 = new TableColumn(table, SWT.NONE);
		column2.setText("TableColumn");
		column2.setWidth(100);
		TableItem item1 = new TableItem(table, SWT.NONE);
		item1.setText(0, "Table");
		item1.setText(1, "TableItem");
		table.setSize(250, 50);
		// Tree
		Composite treeComposite = new Composite(shell, SWT.NONE);
		Tree tree = new Tree(treeComposite, SWT.BORDER);
		TreeItem parent = new TreeItem(tree, SWT.NONE);
		parent.setText("Tree");
		TreeItem child1 = new TreeItem(parent, SWT.NONE);
		child1.setText("TreeItem");
		TreeItem child2 = new TreeItem(parent, SWT.NONE);
		child2.setText("TreeItem");
		parent.setExpanded(true);
		tree.setSelection(parent);
		tree.setSize(120, 90);
		// List
		Composite listComposite = new Composite(shell, SWT.NONE);
		List list = new List(listComposite, SWT.BORDER | SWT.V_SCROLL);
		list.add("List");
		list.add("List");
		list.setSelection(0);
		list.setSize(100, 50);
		// Text
		Composite textComposite = new Composite(shell, SWT.NONE);
		Text text = new Text(textComposite, SWT.BORDER | SWT.V_SCROLL);
		text.append("Text\n");
		text.append("Text\n");
		text.setSize(100, 50);
		// StyledText
		Composite styledTextComposite = new Composite(shell, SWT.NONE);
		StyledText styledText = new StyledText(styledTextComposite, SWT.BORDER);
		styledText.setFont(font);
		styledText.append("StyledText\n");
		styledText.append("StyledText\n");
		styledText.setStyleRange(new StyleRange(6, 11, red, null, SWT.BOLD));
		styledText.setSize(100, 50);
		// Composite
		Composite compositeComposite = new Composite(shell, SWT.NONE);
		Composite composite = new Composite(compositeComposite, SWT.BORDER);
		Label compositeLabel = new Label(composite, SWT.NONE);
		compositeLabel.setText("Composite");
		compositeLabel.setSize(100, 100);
		composite.setSize(120, 50);
		// ScrolledComposite
		Composite scrolledCompositeComposite = new Composite(shell, SWT.NONE);
		ScrolledComposite scrolledComposite = new ScrolledComposite(scrolledCompositeComposite,
				SWT.BORDER | SWT.H_SCROLL | SWT.V_SCROLL);
		Label scrolledCompositeLabel = new Label(scrolledComposite, SWT.BORDER);
		scrolledCompositeLabel.setText("ScrolledComposite");
		scrolledCompositeLabel.setSize(400, 100);
		scrolledComposite.setContent(scrolledCompositeLabel);
		scrolledComposite.setSize(150, 50);
		// Sash
		Composite sashComposite = new Composite(shell, SWT.NONE);
		Sash sash = new Sash(sashComposite, SWT.BORDER | SWT.VERTICAL);
		sash.setSize(15, 50);
		// SashForm
		Composite sashFormComposite = new Composite(shell, SWT.NONE);
		SashForm sashForm = new SashForm(sashFormComposite, SWT.BORDER | SWT.VERTICAL);
		sashForm.setLayout(new FillLayout());
		Label sashFormLabel1 = new Label(sashForm, SWT.NONE);
		sashFormLabel1.setText("SashForm");
		Label sashFormLabel2 = new Label(sashForm, SWT.NONE);
		sashFormLabel2.setText("SashForm");
		sashForm.setWeights(new int[] { 50, 50 });
		sashForm.setSize(150, 50);
		// Group
		Composite groupComposite = new Composite(shell, SWT.NONE);
		Group group = new Group(groupComposite, SWT.NONE);
		group.setLayout(new GridLayout());
		group.setText("Group");
		Button button1 = new Button(group, SWT.RADIO);
		button1.setText("Button1");
		button1.setSelection(true);
		Button button2 = new Button(group, SWT.RADIO);
		button2.setText("Button2");
		group.setSize(100, 80);
		// ExpandBar
		Composite expandBarComposite = new Composite(shell, SWT.NONE);
		ExpandBar expandBar = new ExpandBar(expandBarComposite, SWT.V_SCROLL);
		Composite expandItemComposite = new Composite(expandBar, SWT.NONE);
		expandItemComposite.setLayout(new GridLayout());
		Button expandItemButton1 = new Button(expandItemComposite, SWT.RADIO);
		expandItemButton1.setText("ExpandBar");
		expandItemButton1.setSelection(true);
		Button expandItemButton2 = new Button(expandItemComposite, SWT.RADIO);
		expandItemButton2.setText("ExpandItem");
		ExpandItem expandItem = new ExpandItem(expandBar, SWT.NONE);
		expandItem.setText("ExpandBar");
		expandItem.setImage(image);
		expandItem.setHeight(expandItemComposite.computeSize(SWT.DEFAULT, SWT.DEFAULT).y);
		expandItem.setControl(expandItemComposite);
		expandItem.setExpanded(true);
		expandBar.setSize(200, 90);
		// TabFolder
		Composite tabFolderComposite = new Composite(shell, SWT.NONE);
		TabFolder tabFolder = new TabFolder(tabFolderComposite, SWT.NONE);
		TabItem tabItem1 = new TabItem(tabFolder, SWT.NONE);
		tabItem1.setText("TabFolder");
		TabItem tabItem2 = new TabItem(tabFolder, SWT.NONE);
		tabItem2.setText("TabItem");
		tabItem2.setImage(image);
		tabFolder.setSize(200, 50);
		// CTabFolder
		Composite ctabFolderComposite = new Composite(shell, SWT.NONE);
		CTabFolder ctabFolder = new CTabFolder(ctabFolderComposite, SWT.BORDER);
		CTabItem ctabItem1 = new CTabItem(ctabFolder, SWT.NONE);
		ctabItem1.setText("CTabFolder");
		CTabItem ctabItem2 = new CTabItem(ctabFolder, SWT.NONE);
		ctabItem2.setText("CTabItem");
		ctabItem2.setImage(image);
		ctabFolder.setSize(200, 50);
		// ViewForm
		Composite viewFormComposite = new Composite(shell, SWT.NONE);
		ViewForm viewForm = new ViewForm(viewFormComposite, SWT.BORDER);
		Label viewFormLabelLeft = new Label(viewForm, SWT.BORDER);
		viewFormLabelLeft.setText("topLeft");
		viewForm.setTopLeft(viewFormLabelLeft);
		Label viewFormLabelCenter = new Label(viewForm, SWT.BORDER);
		viewFormLabelCenter.setText("topCenter");
		viewForm.setTopCenter(viewFormLabelCenter);
		Label viewFormLabelRight = new Label(viewForm, SWT.BORDER);
		viewFormLabelRight.setText("topRight");
		viewForm.setTopRight(viewFormLabelRight);
		Label viewFormLabelContent = new Label(viewForm, SWT.BORDER);
		viewFormLabelContent.setText("\nViewForm");
		viewForm.setContent(viewFormLabelContent);
		viewForm.setSize(300, 80);
		// Spinner
		Composite spinnerComposite = new Composite(shell, SWT.NONE);
		Spinner spinner = new Spinner(spinnerComposite, SWT.BORDER);
		spinner.setSelection(50);
		spinner.setSize(50, 20);
		// Slider
		Composite sliderComposite = new Composite(shell, SWT.NONE);
		Slider slider = new Slider(sliderComposite, SWT.BORDER);
		slider.setSelection(50);
		slider.setSize(100, 15);
		// Combo
		Composite comboComposite = new Composite(shell, SWT.NONE);
		Combo combo = new Combo(comboComposite, SWT.BORDER);
		combo.setItems(new String[] { "Combo1", "Combo2" });
		combo.setText("Combo1");
		combo.setSize(100, 20);
		// CCombo
		Composite ccomboComposite = new Composite(shell, SWT.NONE);
		CCombo ccombo = new CCombo(ccomboComposite, SWT.FLAT);
		ccombo.setItems(new String[] { "CCombo1", "CCombo2" });
		ccombo.setText("CCombo1");
		ccombo.setSize(100, 20);
		// ToolBar
		Composite toolBarComposite = new Composite(shell, SWT.NONE);
		ToolBar toolBar = new ToolBar(toolBarComposite, SWT.BORDER);
		ToolItem toolBaritem1 = new ToolItem(toolBar, SWT.PUSH);
		toolBaritem1.setText("ToolBar");
		toolBaritem1.setImage(image);
		ToolItem toolBaritem2 = new ToolItem(toolBar, SWT.PUSH);
		toolBaritem2.setText("ToolItem");
		toolBaritem2.setImage(image);
		toolBar.setSize(200, 50);
		// CoolBar
		Composite coolBarComposite = new Composite(shell, SWT.NONE);
		CoolBar coolBar = new CoolBar(coolBarComposite, SWT.BORDER);
		CoolItem coolBaritem1 = new CoolItem(coolBar, SWT.NONE);
		Button coolBarButton1 = new Button(coolBar, SWT.PUSH);
		coolBarButton1.setText("CoolBar");
		coolBarButton1.setImage(image);
		coolBaritem1.setPreferredSize(100, 20);
		coolBaritem1.setControl(coolBarButton1);
		CoolItem coolBaritem2 = new CoolItem(coolBar, SWT.PUSH);
		Button coolBarButton2 = new Button(coolBar, SWT.PUSH);
		coolBarButton2.setText("CoolItem");
		coolBarButton2.setImage(image);
		coolBaritem2.setControl(coolBarButton2);
		coolBaritem2.setPreferredSize(80, 20);
		coolBar.setSize(200, 40);
		// // OLE
		// Composite oleControlSiteComposite = new Composite(shell,
		// SWT.NONE);
		// OleFrame frame = new OleFrame(oleControlSiteComposite,
		// SWT.BORDER);
		// OleControlSite oleControlSite = new OleControlSite(frame,
		// SWT.NONE, "Excel.Sheet");
		// oleControlSite.doVerb(OLE.OLEIVERB_INPLACEACTIVATE);
		// OleAutomation excelSheet = new OleAutomation(oleControlSite);
		// int[] dispIDs = excelSheet.getIDsOfNames(new String[] { "Application"
		// });
		// Variant pVarResult = excelSheet.getProperty(dispIDs[0]);
		// OleAutomation application = pVarResult.getAutomation();
		// pVarResult.dispose();
		// excelSheet.dispose();
		// frame.setSize(500, 400);
		// oleControlSite.setSize(400, 300);


		// ShellIuWFNgOpen܂B
		shell.open();
		// I܂Ń[v܂B
		while (!shell.isDisposed()) {
			if (!display.readAndDispatch()) {
				display.sleep();
			}
		}
		// IuWFNg܂B
		// application.dispose();
		image.dispose();
		red.dispose();
		font.dispose();
		display.dispose();
	}
}
