package jp.sf.amateras.swt.widget;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class TreeSample {
	public static void main(String[] args) {
		Display display = new Display();
		final Shell shell = new Shell(display);
		shell.setText("TreẽTv");
		shell.setBounds(100, 100, 400, 200);
		// Tree܂B
		final Tree tree = new Tree(shell, SWT.BORDER | SWT.MULTI);
		tree.setSize(200, 100);
		// TreeItemǉ܂(em[h1Ɏqm[h2)
		TreeItem parent = new TreeItem(tree, SWT.NONE);
		parent.setText("em[h");
		TreeItem child1 = new TreeItem(parent, SWT.NONE);
		child1.setText("qm[h1");
		TreeItem child2 = new TreeItem(parent, SWT.NONE);
		child2.setText("qm[h2");
		parent.setExpanded(true); // Tree͊JԂɂ܂B
		// TreeItemǉ܂(2ڂ̐em[h)
		TreeItem parent2 = new TreeItem(tree, SWT.NONE);
		parent2.setText("2ڂ̐em[h");
		// ButtonǉĉꂽƂTreeőI΂Ă鍀ڂ擾܂B
		Button button = new Button(shell, SWT.PUSH);
		button.setText("IĂ鍀ڂ\");
		button.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				String message = "Iڂ̔ԍ:";
				for (int i = 0; i < tree.getSelectionCount(); i++) {
					message += " " + tree.getSelection()[i].getText();
				}
				MessageBox messageBox = new MessageBox(shell);
				messageBox.setMessage(message);
				messageBox.open();
			}
		});
		button.setBounds(0, 110, 150, 20);
		// ShellIuWFNgOpen܂B
		shell.pack();
		shell.open();
		while (!shell.isDisposed()) {
			if (!display.readAndDispatch()) {
				display.sleep();
			}
		}
		display.dispose();
	}
}
