package jp.sf.amateras.swt.layout;

import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public class StackLayoutSample {
	public static void main(String[] args) {
		Display display = new Display();
		Shell shell = new Shell(display);
		shell.setText("StackLayout̃Tv");
		shell.setBounds(100, 100, 400, 150);
		// Group쐬StackLayoutݒ肵܂
		final Group group = new Group(shell, SWT.NONE);
		group.setText("StackLayout");
		group.setBounds(10, 10, 200, 50);
		final StackLayout layout = new StackLayout();
		layout.marginHeight = 5;
		layout.marginWidth = 5;
		group.setLayout(layout);
		// GroupLabelButton(WI{^)쐬܂
		final Label label = new Label(group, SWT.BORDER | SWT.CENTER);
		label.setText("1ԖڂLabel");
		final Button radioButton = new Button(group, SWT.RADIO | SWT.BORDER);
		radioButton.setText("2ԖڂRadioButton");
		radioButton.setSelection(true);
		// ԎOLabelZbg܂
		layout.topControl = label;
		group.layout(); // Zbge𔽉f邽߂layout()Ăяo܂
		// ÕEBWFbg؂ւ邽߂Buttonǉ܂
		Button button = new Button(shell, SWT.PUSH);
		button.setText("؂ւ");
		button.setBounds(10, 70, 100, 20);
		button.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				if (layout.topControl.equals(label)) {
					layout.topControl = radioButton;
				} else {
					layout.topControl = label;
				}
				group.layout(); // ؂ւ𔽉f邽߂layout()Ăяo܂
			}
		});
		// ShellIuWFNgOpen܂
		shell.pack();
		shell.open();
		while (shell != null && !shell.isDisposed()) {
			if (!display.readAndDispatch())
				display.sleep();
		}
		display.dispose();
	}
}
