package jp.sf.amateras.swt.layout;

import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class FormLayoutSample {
	public static void main(String[] args) {
		Display display = new Display();
		Shell shell = new Shell(display);
		shell.setText("FormLayout̃Tv");
		shell.setBounds(100, 100, 500, 200);
		shell.setLayout(new FormLayout());
		// ShellɃEBWFbgǉ܂
		// 㕔Labelǉ܂
		Label topLabel = new Label(shell, SWT.BORDER);
		topLabel.setText("Labelzu܂B");
		FormData topForm = new FormData();
		topForm.top = new FormAttachment(0, 1);
		topForm.left = new FormAttachment(0, 1);
		topForm.right = new FormAttachment(100, -1);
		topLabel.setLayoutData(topForm);
		// Labelǉ܂
		Label leftLabel = new Label(shell, SWT.BORDER | SWT.WRAP);
		leftLabel.setText("Label\n5sNZ\nLabelzu\n܂B");
		FormData leftForm = new FormData();
		leftForm.top = new FormAttachment(topLabel, 5);
		leftForm.left = new FormAttachment(0, 1);
		leftForm.bottom = new FormAttachment(100, -1);
		leftLabel.setLayoutData(leftForm);
		// EButtonǉ܂
		Button rightButton = new Button(shell, SWT.PUSH);
		rightButton.setText("E[Buttonzu܂");
		FormData bottomRightForm = new FormData();
		bottomRightForm.bottom = new FormAttachment(100, -5);
		bottomRightForm.right = new FormAttachment(100, -5);
		rightButton.setLayoutData(bottomRightForm);
		// ׂ̗ɂButtonǉ܂
		Button leftButton = new Button(shell, SWT.PUSH);
		leftButton.setText("ׂɂ1Buttonzu܂");
		FormData bottomLeftForm = new FormData();
		bottomLeftForm.bottom = new FormAttachment(100, -5);
		bottomLeftForm.right = new FormAttachment(rightButton, -5);
		leftButton.setLayoutData(bottomLeftForm);
		// ŌTextǉ܂
		Text text = new Text(shell, SWT.BORDER);
		text.append("c̗̈Textzu܂B");
		FormData centerForm = new FormData();
		centerForm.top = new FormAttachment(topLabel, 5);
		centerForm.left = new FormAttachment(leftLabel, 5);
		centerForm.bottom = new FormAttachment(rightButton, -5);
		centerForm.right = new FormAttachment(100, -5);
		text.setLayoutData(centerForm);
		// ShellIuWFNgOpen܂
		shell.open();
		while (shell != null && !shell.isDisposed()) {
			if (!display.readAndDispatch())
				display.sleep();
		}
		display.dispose();
	}
}
