﻿package {
	import flash.display.Sprite;
	import flash.display.BitmapData;
	import flash.display.TriangleCulling;
	import flash.geom.PerspectiveProjection;
	import flash.geom.Matrix3D;
	import flash.geom.Vector3D;
	import flash.geom.Utils3D;
	public class Cube extends Sprite {
		private var unit:Number;
		private var texture:BitmapData;
		private var vertices3D:Vector.<Number> = new Vector.<Number>();
		private var indices:Vector.<int> = new Vector.<int>();
		private var uvtData:Vector.<Number> = new Vector.<Number>();
		private var distance:Number;
		private var myPerspective:PerspectiveProjection = new PerspectiveProjection();
		private var worldMatrix3D:Matrix3D = new Matrix3D();
		private var viewMatrix3D:Matrix3D = new Matrix3D();
		public function Cube(myTexture:BitmapData, edge:Number = 100, nDistance:Number = 300) {
			texture = myTexture;
			unit = edge / 2;
			myPerspective.focalLength = distance = nDistance;
			vertices3D.push(-unit, -unit, -unit);
			vertices3D.push(unit, -unit, -unit);
			vertices3D.push(unit, unit, -unit);
			vertices3D.push(-unit, unit, -unit);
			vertices3D.push(-unit, -unit, unit);
			vertices3D.push(unit, -unit, unit);
			vertices3D.push(unit, unit, unit);
			vertices3D.push(-unit, unit, unit);
			vertices3D.push(-unit, -unit, -unit);
			vertices3D.push(-unit, unit, -unit);
			vertices3D.push(-unit, -unit, unit);
			vertices3D.push(unit, -unit, unit);
			vertices3D.push(unit, unit, unit);
			vertices3D.push(-unit, unit, unit);
			addRectangleIndices(0, 1, 2, 3);
			addRectangleIndices(1, 5, 6, 2);
			addRectangleIndices(5, 4, 7, 6);
			addRectangleIndices(4, 8, 9, 7);
			addRectangleIndices(1, 0, 10, 11);
			addRectangleIndices(3, 2, 12, 13);
			uvtData.push(0, 1/3, 0);
			uvtData.push(1/4, 1/3, 0);
			uvtData.push(1/4, 2/3, 0);
			uvtData.push(0, 2/3, 0);
			uvtData.push(3/4, 1/3, 0);
			uvtData.push(2/4, 1/3, 0);
			uvtData.push(2/4, 2/3, 0);
			uvtData.push(3/4, 2/3, 0);
			uvtData.push(1, 1/3, 0);
			uvtData.push(1, 2/3, 0);
			uvtData.push(0, 0, 0);
			uvtData.push(1/4, 0, 0);
			uvtData.push(1/4, 1, 0);
			uvtData.push(0, 1, 0);
			viewMatrix3D.appendTranslation(0, 0, distance);
			viewMatrix3D.append(myPerspective.toMatrix3D());
			rotate(0, 0);
		}
		public function rotate(nRotationX, nRotationY):void {
			var vertices2D:Vector.<Number> = new Vector.<Number>();
			worldMatrix3D.appendRotation(nRotationY, Vector3D.Y_AXIS);
			worldMatrix3D.appendRotation(nRotationX, Vector3D.X_AXIS);
			var myMatrix3D:Matrix3D = worldMatrix3D.clone();
			myMatrix3D.append(viewMatrix3D);
			Utils3D.projectVectors(myMatrix3D, vertices3D, vertices2D, uvtData);
			graphics.clear();
			graphics.beginBitmapFill(texture);
			graphics.drawTriangles(vertices2D, indices, uvtData, TriangleCulling.NEGATIVE);
			graphics.endFill();
		}
		private function addRectangleIndices(n0:uint, n1:uint, n2:uint, n3:uint):void {
			indices.push(n0, n1, n3);
			indices.push(n1, n2, n3);
		}
	}
}