﻿package {
	import flash.display.Sprite;
	import flash.geom.Matrix3D;
	import flash.geom.Vector3D;
	import flash.geom.Point;
	public class WireCube extends Sprite {
		private var unit:Number;
		private var vertices:Vector.<Vector3D> = new Vector.<Vector3D>();
		private var indices:Vector.<Vector.<uint>> = new Vector.<Vector.<uint>>();
		private var focalLength:Number;
		private var thickness:Number;
		private var color:uint;
		public function WireCube(edge:Number = 100, nThickness:Number = 2, nColor:uint = 0) {
			unit = edge / 2;
			focalLength = unit * 10;
			thickness = nThickness;
			color = nColor;
			vertices.push(new Vector3D(-unit, -unit, -unit));
			vertices.push(new Vector3D(unit, -unit, -unit));
			vertices.push(new Vector3D(unit, unit, -unit));
			vertices.push(new Vector3D(-unit, unit, -unit));
			vertices.push(new Vector3D(-unit, -unit, unit));
			vertices.push(new Vector3D(unit, -unit, unit));
			vertices.push(new Vector3D(unit, unit, unit));
			vertices.push(new Vector3D(-unit, unit, unit));
			indices.push(Vector.<uint>([0, 1, 2, 3]));
			indices.push(Vector.<uint>([4, 5, 6, 7]));
			indices.push(Vector.<uint>([0, 4]));
			indices.push(Vector.<uint>([1, 5]));
			indices.push(Vector.<uint>([2, 6]));
			indices.push(Vector.<uint>([3, 7]));
			rotate(new Point(0, 0));  // 念のため追加
		}
		public function rotate(myRotation:Point):void {
			transformVertices(vertices, myRotation);
			var vertices2D:Vector.<Point> = getVertices2D(vertices);
			drawCube(vertices2D, indices);
		}
		private function transformVertices(myVertices:Vector.<Vector3D>, myRotation:Point):void {
			var nLength:uint = myVertices.length;
			var myMatrix3D:Matrix3D = new Matrix3D();
			myMatrix3D.appendRotation(myRotation.x, Vector3D.Y_AXIS);
			myMatrix3D.appendRotation(myRotation.y, Vector3D.X_AXIS);
			for (var i:int = 0; i<nLength; i++) {
				myVertices[i] = myMatrix3D.transformVector(myVertices[i]);
			}
		}
		private function getVertices2D(myVertices:Vector.<Vector3D>):Vector.<Point> {
			var vertices2D:Vector.<Point> = new Vector.<Point>();
			var nLength:uint = myVertices.length;
			for (var i:uint = 0; i < nLength; i++) {
				var myVector3D:Vector3D = myVertices[i].clone();
				myVector3D.w = (focalLength + myVector3D.z) / focalLength;
				myVector3D.project();
				vertices2D.push(new Point(myVector3D.x, myVector3D.y));
			}
			return vertices2D;
		}
		private function drawCube(vertices2D:Vector.<Point>, myIndices:Vector.<Vector.<uint>>):void {
			var nLength:uint = myIndices.length;
			graphics.clear();
			for (var i:uint = 0; i < nLength; i++) {
				var myVertices:Vector.<Point> = new Vector.<Point>();
				var myIndex:Vector.<uint> = myIndices[i];
				var nLength2:uint = myIndex.length;
				for (var j:uint = 0; j < nLength2; j++) {
					myVertices.push(vertices2D[myIndex[j]]);
				}
				drawLines(myVertices);
			}
		}
		private function drawLines(vertices2D:Vector.<Point>):void {
			var nLength:uint = vertices2D.length;
			var myPoint:Point = vertices2D[nLength - 1];
			if (nLength < 3) {
				--nLength;
			}
			graphics.lineStyle(thickness, color);
			graphics.moveTo(myPoint.x, myPoint.y);
			for (var i:uint = 0; i < nLength; i++) {
				myPoint = vertices2D[i];
				graphics.lineTo(myPoint.x, myPoint.y);
			}
		}
	}
}