﻿package {
	import flash.display.DisplayObject;
	import flash.display.Sprite;
	import flash.geom.Matrix3D;
	import flash.geom.Vector3D;
	import flash.events.Event;
	public class Cube extends Sprite {
		private var unit:Number;
		private var frontFace:Sprite;
		private var backFace:Sprite;
		private var leftFace:Sprite;
		private var rightFace:Sprite;
		private var topFace:Sprite;
		private var bottomFace:Sprite;
		private var myMatrix3D:Matrix3D;
		private var culling:Boolean = true;
		public function Cube(front:DisplayObject = null, back:DisplayObject = null, left:DisplayObject = null, right:DisplayObject = null, top:DisplayObject = null, bottom:DisplayObject = null, edge:Number = 100) {
			unit = edge / 2;
			z = 0;
			myMatrix3D = transform.matrix3D;
			frontFace = createFace(front, 0, 0, -unit);
			backFace = createFace(back, 0, 0, unit, 180, 0);
			leftFace = createFace(left, -unit, 0, 0, 90, 0);
			rightFace = createFace(right, unit, 0, 0, -90, 0);
			topFace = createFace(top,0, -unit, 0, 0, -90);
			bottomFace = createFace(bottom, 0, unit, 0, 0, 90);
			addEventListener(Event.ADDED, onAdded);
		}
		public function rotate(nRotationY:Number, nRotationX:Number):void {
			var nX:Number = x;
			var nY:Number = y;
			myMatrix3D.appendTranslation(-nX, -nY, 0);
			myMatrix3D.appendRotation(nRotationY, Vector3D.Y_AXIS);
			myMatrix3D.appendRotation(nRotationX, Vector3D.X_AXIS);
			myMatrix3D.appendTranslation(nX, nY, 0);
			setOrder();
		}
		private function setOrder():void {
			var faces_array:Array = new Array();
			var nChildren:uint = numChildren;
			var i:uint;
			var faceSprite:Sprite;
			for (i = 0; i < nChildren; i++) {
				faceSprite = getChildAt(i) as Sprite;
				var myVector3D:Vector3D = faceSprite.transform.getRelativeMatrix3D(parent).position;
				var nZ:Number = myVector3D.z;
				if (! culling) {
					faces_array.push({face:faceSprite, z:nZ});
				} else {
					if (nZ < 0) {
						faceSprite.visible = true;
						faces_array.push({face:faceSprite, z:nZ});
					} else {
						faceSprite.visible = false;
					}
				}
			}
			faces_array.sortOn("z", Array.NUMERIC | Array.DESCENDING);
			var nStart:uint = nChildren - faces_array.length;
			for (i = nStart; i < nChildren; i++) {
				faceSprite = faces_array[i - nStart].face;
				setChildIndex(faceSprite, i);
			}
		}
		private function onAdded(eventObject:Event):void {
			setOrder();
		}
		private function createFace(face:DisplayObject, nX:Number, nY:Number, nZ:Number, nRotationY:Number = 0, nRotationX:Number = 0):Sprite {
			var faceSprite:Sprite = null;
			if (face) {
				faceSprite = new Sprite();
				addChild(faceSprite);
				faceSprite.addChild(face);
				faceSprite.x = nX;
				faceSprite.y = nY;
				faceSprite.z = nZ;
				faceSprite.rotationY = nRotationY;
				faceSprite.rotationX = nRotationX;
				face.width = unit * 2;
				face.height = unit * 2;
				face.x = -unit;
				face.y = -unit;
			} else {
				culling = false;
			}
			return faceSprite;
		}
	}
}