// GUIText格納用変数
var keyInputText:GUIText;
// 点滅間隔
var waitTime:float = 1.0;
// 点滅制御状態フラグ
private var blinkFlg:boolean = false;
// 画面下部に表示する文字
private var text : String;

// シーン起動時に一度だけ実行される処理
function Start(){
	// 画面表示文字を取得
	text = keyInputText.text;
}

// シーン表示中に随時行われる処理
function Update(){
	// "A"キーが押された場合
	if(Input.GetKeyDown("a")){
		// シーン番号に"1"が設定されているシーンを読み込む
		Application.LoadLevel(1);
	}
	// 点滅制御待機状態(フラグ値=false)の場合
	if(!blinkFlg){
		// 2点滅制御を呼び出す
		brinkKeyInput();
	}
	// 画面のどこかをタッチしている場合
	if(Input.touchCount > 0){
		// １面を読み込む
		Application.LoadLevel("JumpMan_01");
	}
}

// 点滅制御
function brinkKeyInput(){
	// 点滅制御中状態に変更
	blinkFlg = true;

	// 画面に文字を表示する
	keyInputText.text = text;

	// waitTimeの秒数分待機する
	yield WaitForSeconds(waitTime);

	// 画面の文字を消す
	keyInputText.text = "";

	// waitTimeの半分だけ待機する
	yield WaitForSeconds(waitTime/2);

	// 点滅制御待機状態に変更
	blinkFlg = false;
}
