// アイテム所持フラグ
private var itemFlg = false;
// クリアフラグ
private var clearFlg = false;

// プレイヤーが接触判定を持つオブジェクトに接触すると行われる処理
function OnControllerColliderHit(hit : ControllerColliderHit){
	// 接触相手のオブジェクト情報を取得
	var obj = hit.gameObject;

	// 自オブジェクト情報を取得
	var player = hit.controller.gameObject;
	
	// RefreshAreaに接触した場合
	if(obj.name == "RefreshArea"){
		// シーンを再読み込みする
		Application.LoadLevel("JumpMan_01");
	}

	// FirePlugに接触 かつ レンチを所持している場合
	if(obj.name == "FirePlug" && itemFlg == true){
		// 接触したオブジェクトからWater Fountainオブジェクトを取得
		var objWater = gameObject.Find("Water Fountain");

		// 取得したWater FountainオブジェクトからParticleRendererのコンポーネントを取得
		var compPartRend = objWater.GetComponent(ParticleRenderer);

		// 取得したParticleRendererのコンポーネントを無効にする
		compPartRend.enabled = false;

		// クリア可能状態に設定
		clearFlg = true;
	}

	// Itemに接触した場合
	if(obj.name == "Item"){
		// アイテム所持フラグをtrueにする
		itemFlg = true;

		// Itemを消滅させる
		Destroy(obj);

		// 手元のレンチの表示を復活させる
		var objWrench = player.Find("wrench");
		
		// 取得したレンチオブジェクトからMeshRendererのコンポーネントを取得
		var compMeshRend = objWrench.GetComponent(MeshRenderer);

		// 取得したMeshRendererのコンポーネントを有効にする
		compMeshRend.enabled = true;
	}

	// Startに接触 かつ クリア可能状態の場合
	if(obj.name == "Start" && clearFlg == true){
		// クリア画面を読み込む
		Application.LoadLevel("JumpMan_clear");
	}
}
