<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="<?php bloginfo('html_type'); ?>; charset=<?php bloginfo('charset'); ?>" />

<title><?php bloginfo('name'); ?><?php wp_title(': '); ?></title>

<meta name="generator" content="WordPress <?php bloginfo('version'); ?>" /> <!-- leave this for stats please -->

<link rel="alternate" type="application/rss+xml" title="<?php bloginfo('name'); ?>（RSS 2.0）" href="<?php bloginfo('rss2_url'); ?>" />

<link rel="alternate" type="application/atom+xml" title="<?php bloginfo('name'); ?>（Atom）" href="<?php bloginfo('atom_url'); ?>" />

<link rel="stylesheet" type="text/css" href="<?php bloginfo('stylesheet_url'); ?>" />
</head>
<body>

<div id="container">

<div id="header">
<h1><a href="<?php bloginfo('url'); ?>"><?php bloginfo('name'); ?></a></h1>
<p><?php bloginfo('description'); ?></p>
</div>


<div id="main">

<div id="content">

<?php if ( have_posts() ) : while ( have_posts() ) : the_post(); ?>

<div class="post">
<h2><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h2>
<?php the_content(); ?>

<p class="postmetadata">
| <a href="<?php the_permalink(); ?>"><?php the_time('Y年m月d日 H:i') ?></a>
| <?php the_category(', ') ?> 
| <?php comments_popup_link('コメント＆トラックバック（0）', 'コメント＆トラックバック（1）', 'コメント＆トラックバック（%）'); ?> 
</p>
</div>

<?php comments_template(); ?>

<?php endwhile; endif; ?>

<div class="pagenav">
<p><?php posts_nav_link(' | ', '&laquo; 前のページ', '次のページ &raquo;'); ?></p>
</div>

</div>


<div id="sidebar">

<!-- カレンダー -->
<div id="calendar">
<h2>カレンダー</h2>
<?php get_calendar(); ?>
</div>

<!-- 最近の記事 -->
<div id="recentposts">
<h2>最近の記事</h2>
<ul>
<?php wp_get_archives('type=postbypost&limit=10'); ?>
</ul>
</div>

<!-- カテゴリー -->
<div id="category">
<h2>カテゴリー</h2>
<ul>
<?php wp_list_cats('children=1 & hide_empty=0 & hierarchical=1 & optioncount=1'); ?>
</ul>
</div>

<!-- 月別アーカイブ -->
<div id="archives">
<h2>アーカイブ</h2>
<ul>
<?php wp_get_archives('type=monthly'); ?>
</ul>
</div>

</div>

</div>

<div id="footer">
<address>Copyright (C) TARO</address>
</div>

</div>

</body>
</html>
