import System.Random

type Pt = (Int, Int)
type Board = [[Ball]]

isFinished :: Board -> Bool
isFinished board = and $ concat $ zipWith (\x column -> zipWith (\y _ -> (length (markBoard board (x, y)) <= 1)) [0..] column) [0..] board

isValidPos :: Board -> Pt -> Bool
isValidPos [] _               = False
isValidPos (column:_)  (0, y) = y >= 0 && y < length column
isValidPos (_:columns) (x, y) = isValidPos columns (x-1, y)

markBoard :: Board -> Pt -> [Pt]
markBoard board pt@(x, y) = loop pt []
    where ball = board !! x !! y
          loop pt@(x, y) marks
              | isValidPos board pt && board !! x !! y == ball =
                  foldr loop (pt:marks) $
                        filter (flip notElem marks) 
                               [(x+1,y),(x-1,y),(x,y+1),(x,y-1)]
              | otherwise = marks

pickBall :: Board -> [Pt] -> Board
pickBall board marks = filter ((/=0).length) $ zipWith (\x column -> snd $ unzip $ filter (\ (y, ball) -> notElem (x, y) marks) $ zip [0..] column) [0..] board

data Ball = Red | Blue | Yellow deriving (Eq, Show)
testBoard = [[Red, Red, Red, Blue, Blue]
            ,[Blue, Red, Red, Yellow, Blue]
            ,[Blue, Yellow, Yellow, Blue, Blue]
            ,[Yellow, Yellow, Red, Red, Yellow]
            ,[Red, Blue, Blue, Red, Yellow]]

colors = [Red, Blue, Yellow]
mkRandomBoard :: Int -> Int -> Int -> IO Board
mkRandomBoard x y cols = 
    do seed <- getStdGen
       rs <- return $ randomRs (0, cols-1) seed
       return $ take x $ mkTable y $ map (colors!!) rs
    where mkTable n list = column : mkTable n rest
              where (column, rest) = splitAt n list

calcScore marks = (length marks - 2) * (length marks - 2)
samegame board score
               = do print board
                    x <- getLine >>= return . read
                    y <- getLine >>= return . read
                    marks <- return $ markBoard board (x, y)
                    if length marks <= 1 
                      then samegame board score
                      else do newBoard <- return $ pickBall board marks
                              newScore <- return $ score + calcScore marks
                              if isFinished newBoard 
                                 then return newScore
                                 else samegame newBoard newScore

main = do board <- mkRandomBoard 15 10 3
          score <- samegame board 0
          putStrLn $ "Your Score is: " ++ show score
