import Control.Monad
import Maybe

data Sheep = Sheep { name :: String
		   , age :: Int
		   , mother :: Maybe Sheep
		   , father :: Maybe Sheep } deriving (Show)

maternalGrandfather s = mother s >>= father
agnaticGrandfather s  = father s >>= father

grandfathers s = catMaybes [ mother s >>= father, father s >>= father ]

grandfather s = (mother s >>= father) `mplus` (father s >>= father)

lookupGrandfather s a =
    do gf <- mother s >>= father
       youngerThan gf a
    `mplus`
    do gf <- father s >>= father
       youngerThan gf a
    where youngerThan s a = do guard (age s < a)
			       return s

s1 = Sheep {name="a", age = 10, mother = Nothing, father = Nothing}
s2 = Sheep {name="b", age = 11, mother = Nothing, father = Nothing}
s3 = Sheep {name="c", age = 6, mother = Just s1, father = Just s2}
s4 = Sheep {name="d", age = 6, mother = Just s1, father = Nothing}
s5 = Sheep {name="e", age = 2, mother = Just s3, father = Just s4}