import Control.Monad.State
import Data.Char
import Data.Bits

data B64EncState = First | Second Int | Third Int


table = ['A'..'Z'] ++ ['a'..'z'] ++ ['0'..'9'] ++ "+/"

procChar :: Int -> State B64EncState String
procChar c = get >>= transit
    where
    transit  First     = do put $ Second (c .&. 3)
                            return [table !! shiftR c 2]
    transit (Second n) = do put $ Third (c .&. 15)
                            return [table !! (shiftL n 4 .|. shiftR c 4)]
    transit (Third  n) = do put First
                            return [ table !! (shiftL n 2 .|. shiftR c 6)
                                   , table !! (c .&. 63)]

calcSuffix :: B64EncState -> String
calcSuffix  First     = "\n"
calcSuffix (Second n) = table !! shiftR n 4 : "==\n"
calcSuffix (Third  n) = table !! shiftR n 2 : "=\n"

b64Enc s = do strs <- mapM (procChar.ord) s
              suffix <- gets calcSuffix
              return (concat strs ++ suffix)

base64Encode s = evalState (b64Enc s) First
