data BinTree a = Leaf | Node a (BinTree a) (BinTree a) deriving Show

lengthTree Leaf         = 0
lengthTree (Node _ l r) = 1 + lengthTree l + lengthTree r

mapTree _ Leaf         = Leaf
mapTree f (Node x l r) = Node (f x) (mapTree f l) (mapTree f r)

lookupTree :: Ord k => k -> BinTree (k,v) -> Maybe v
lookupTree x Leaf = Nothing
lookupTree x (Node (k, v) l r)
   | x < k     = lookupTree x l
   | x > k     = lookupTree x r
   | otherwise = Just v

insertTree :: Ord k => (k, v) -> BinTree (k, v) -> BinTree (k, v)
insertTree (k', v') Leaf = Node (k', v') Leaf Leaf
insertTree (k', v') (Node (k, v) l r)
   | k' < k    = Node (k, v) (insertTree (k', v') l) r
   | k' > k    = Node (k, v) l (insertTree (k', v') r)
   | otherwise = Node (k, v') l r

emptyTree = Leaf

listToTree :: Ord k => [(k,v)] -> BinTree (k,v)
listToTree = foldl (\t (k, v) -> insertTree (k, v) t) emptyTree

treeToList Leaf         = []
treeToList (Node x l r) = x : treeToList l ++ treeToList r
