import Char
import System.Environment

bytesCount []     = 0
bytesCount (c:cs) = 1 + bytesCount cs

linesCount []        = 0
linesCount ('\n':cs) = 1 + linesCount cs
linesCount (c:cs)    = linesCount cs

wordsCount :: String -> Int
wordsCount str = outWords str
    where wordScan f [] = 0
          wordScan f (c:cs)
              | isAlphaNum c = f (inWords cs)
              | otherwise    = outWords cs
          outWords :: String -> Int
          outWords str = wordScan (\n -> 1 + n) str
          inWords :: String -> Int
          inWords str = wordScan id str

wcFile fileName =
    do contents <- readFile fileName
       putStrLn ("\t" ++ show (linesCount contents)
                 ++ "\t" ++ show (wordsCount contents)
                 ++ "\t" ++ show (bytesCount contents)
                 ++ "\t" ++ fileName)

main = do args <- getArgs
	  mapM_ wcFile args
