﻿package {
    import flash.display.*;
    import flash.events.*;
    import flash.media.*;
    import flash.net.*;
    import flash.text.*;

    //動画ストリーミングの再生
    public class VideoEx extends Sprite {
        private var label:TextField;         //ラベル
        private var connection:NetConnection;//コネクション
        private var stream:NetStream;        //ストリーム

		//コンストラクタ
        public function VideoEx() {
            //ラベルの追加
            label=addLabel("VideoEx");

        	//コネクションの生成
            connection=new NetConnection();
            
            //イベントリスナーの追加
            connection.addEventListener(
            	NetStatusEvent.NET_STATUS,netStatusHandler);
            connection.addEventListener(
            	SecurityErrorEvent.SECURITY_ERROR,securityErrorHandler);
            	
            //ファイルとの接続を確立
            connection.connect(null);
        }

		//ネット状態イベントの処理
        private function netStatusHandler(evt:NetStatusEvent):void {
            switch (evt.info.code) {
            	//成功
                case "NetConnection.Connect.Success":
                	//ストリームの生成
		            var stream:NetStream=new NetStream(connection);
		            
		            //イベントリスナーの追加
		            stream.addEventListener(
		            	NetStatusEvent.NET_STATUS,netStatusHandler);
		            stream.addEventListener(
		            	AsyncErrorEvent.ASYNC_ERROR,asyncErrorHandler);

					//動画の表示領域の生成
		            var video:Video=new Video(128,96);
		            video.x=56;
        		    video.y=72;
		            addChild(video);
		            video.attachNetStream(stream);
		            
		            //動画ストリーミングの再生開始
		            stream.play("sample.flv");	            
                    break;
                //ファイルが見つからない
                case "NetStream.Play.StreamNotFound":
                    label.text="ファイルが見つからない";
                    break;
            }
        }

        //非同期エラーイベントの処理
        private function asyncErrorHandler(evt:AsyncErrorEvent):void {
        }

        //セキュリティエラーイベントの処理
        private function securityErrorHandler(evt:SecurityErrorEvent):void {
            label.text="セキュリティエラー";
        }

        //ラベルの追加
        private function addLabel(text:String):TextField {
            var label:TextField=new TextField();
            addChild(label);
            label.text=text;
            label.autoSize=TextFieldAutoSize.LEFT;
            label.selectable=false;
            return label;
        }
    }
 }