package {
    import flash.display.*;
    import flash.events.*;
    import flash.text.*;
    import flash.utils.*;
    import flash.geom.Rectangle;

    //シューティングゲーム
    public class ShootingGame extends Sprite {
	    //シーン定数
	    private static const S_TITLE:int   =0;//タイトル
	    private static const S_PLAY:int    =1;//プレイ
	    private static const S_TIMEOVER:int=2;//タイムオーバー

        //素材クラス
        [Embed(source='background.swf')]
        private var BackGround:Class;
        [Embed(source='fighter.swf')]
        private var Fighter:Class;
        
        //素材オブジェクト
        private var fighter:Sprite;          //戦闘機
        private var enemy:Array=new Array(0);//敵機
        
        //システム
    	private var init:int =S_TITLE;//初期化
    	private var scene:int=S_TITLE;//シーン
    	private var score:int=0;      //スコア
    	private var time:int =0;      //タイム
		private var base:Sprite;      //クリック対象となるスプライト
		
		//ラベル
		private var lblTitle:TextField;//タイトル
		private var lblScore:TextField;//スコア
		private var tfTitle:TextFormat;//タイトル書式
		private var tfScore:TextFormat;//スコア書式

        //コンストラクタ
        public function ShootingGame() { 
        	var i:int;      

            //クリック対象となるスプライトの追加
            base=new Sprite();
            base.graphics.beginFill(0xFFFFFF);
            base.graphics.drawRect(0,0,640,480);
            base.graphics.endFill();
            addChild(base);

            //背景の生成
            base.addChild(new BackGround());
            
            //戦闘機の生成
            fighter=new Fighter();
		    fighter.x=320;
            fighter.y=300;
            base.addChild(fighter);
            
            //ラベルの生成
            lblScore=Util.makeLabel(0,0,0,0,TextFieldAutoSize.LEFT);
            base.addChild(lblScore);
            lblTitle=Util.makeLabel(0,80,640,80,TextFieldAutoSize.CENTER);
            base.addChild(lblTitle);
            
            //ラベル書式の生成
            tfTitle=Util.makeTextFormat(50,0xFF3333);
            tfScore=Util.makeTextFormat(30,0xEE4444);
            
            //マスクの指定
            var rect:Shape=new Shape();
            rect.graphics.beginFill(0x000000);
            rect.graphics.lineStyle(0,0x000000);
            rect.graphics.drawRect(0,0,640,480);
            rect.graphics.endFill();
            this.mask=rect;

            //イベントリスナーの追加
            base.addEventListener(
            	MouseEvent.MOUSE_DOWN,mouseDownHandler);
           
            //タイマーの追加
            var timer:Timer=new Timer(100,0);
            timer.addEventListener(TimerEvent.TIMER,onTick);
            timer.start();
        }

        //マウスダウンイベントの処理
        private function mouseDownHandler(evt:MouseEvent):void {
                 if (scene==S_TITLE)    init=S_PLAY;
            else if (scene==S_TIMEOVER) init=S_TITLE;
        }

        //タイマーイベントの処理
        private function onTick(evt:TimerEvent):void {
        	var i:int,idx:int,e:Enemy;

            //初期化
            if (init>=0) {
                //タイトル
                if (init==S_TITLE) {
                    score    =0;
                    time     =300;
		            fighter.x=320;
		            fighter.y=300;
		            enemy.splice(0,enemy.length);
		            lblTitle.text="スペースジーク";
		            lblTitle.setTextFormat(tfTitle);
                } 
                //プレイ
                else if (init==S_PLAY) {
                	lblTitle.text="";
		            lblTitle.setTextFormat(tfTitle);
                }
                //タイムオーバー
                else if (init==S_TIMEOVER) {
                	lblTitle.text="任務完了";
		            lblTitle.setTextFormat(tfTitle);
		        	fighter.rotation=0;
                }
                //共通の初期化
                scene=init;
                init =-1;
            }

            //プレイ
            if (scene==S_PLAY) {
            	//スコア
            	if (--time<10) init=S_TIMEOVER;
            	lblScore.text="SCORE:"+score+"\nTIME :"+Math.floor(time/10);
            	lblScore.setTextFormat(tfScore);
            	
            	//敵機の撃ち落し判定          	
                for (i=0;i<enemy.length;i++) {
			        if (enemy[i].isHit(fighter.x,fighter.y)) {
			           	idx=base.getChildIndex(enemy[i].normal);
					    base.removeChild(enemy[i].normal);
						base.addChildAt(enemy[i].bom,idx);
						score+=10;
			       }
                }

	        	//戦闘機の移動        	
	        	fighter.rotation=0;
	        	if (Math.abs(mouseX-fighter.x)<60) fighter.x=mouseX;
	        	if (Math.abs(mouseY-fighter.y)<40) fighter.y=mouseY;
	        	if (mouseX<fighter.x) {fighter.x-=60;fighter.rotation=-10;}
	        	if (mouseX>fighter.x) {fighter.x+=60;fighter.rotation=10;}
	        	if (mouseY<fighter.y) fighter.y-=40;
	        	if (mouseY>fighter.y) fighter.y+=40;
            }

			//敵機の移動と削除
            for (i=0;i<enemy.length;i++) {
            	//敵の移動
            	if (enemy[i].move()) continue;
            	//敵の削除
            	if (enemy[i].bom==null) {
					base.removeChild(enemy[i].normal);
            	} else {
	            	base.removeChild(enemy[i].bom);
	            }
				enemy.splice(i,1);
            }

            //敵機の出現
            if (scene==S_PLAY && Util.rand(100)<30) {
               	e=new Enemy();
                base.addChildAt(e.normal,1);
             	enemy.push(e);
            }
        }
    }
}