package {
    import flash.display.*;
    import flash.events.*;
    import flash.ui.*;
    
    //Java風キャンバスラッパー
    public class JCanvas extends Sprite {
        //定数
        public static const KEY_NONE:int=-999;

        //変数
        protected var g:JGraphics;//グラフィックス
        private   var base:Sprite;//キー入力対象となるスプライト  

        //コンストラクタ
        public function JCanvas(w:int,h:int) {            
            //キー入力対象となるスプライトの生成
            base=new Sprite();
            base.focusRect=false;
            addChild(base);
            
            //グラフィックスの生成
            g=new JGraphics(w,h);
            var bmp:Bitmap=new Bitmap(g.getBitmapData());
            base.addChild(bmp);

            //イベントリスナーの指定
            base.addEventListener(KeyboardEvent.KEY_DOWN,keyDownHandler);
            base.addEventListener(KeyboardEvent.KEY_UP,keyUpHandler);  
            base.addEventListener(MouseEvent.CLICK,clickHandler);      
            stage.focus=base;
        }
        
        //キーイベントの処理
        public function processEvent(type:int,param:int):void {
        }
        
        //キーパラメータの計算
        private function calcKeyParam(keyCode:int):int {
            switch (keyCode) {
                case 48:
                case Keyboard.NUMPAD_0:
                    return Display.KEY_0;
                case 49:
                case Keyboard.NUMPAD_1:
                    return Display.KEY_1;
                case 50:
                case Keyboard.NUMPAD_2:
                    return Display.KEY_2;
                case 51:
                case Keyboard.NUMPAD_3:
                    return Display.KEY_3;
                case 52:
                case Keyboard.NUMPAD_4:
                    return Display.KEY_4;
                case 53:
                case Keyboard.NUMPAD_5:
                    return Display.KEY_5;
                case 54:
                case Keyboard.NUMPAD_6:
                    return Display.KEY_6;
                case 55:
                case Keyboard.NUMPAD_7:
                    return Display.KEY_7;
                case 56:
                case Keyboard.NUMPAD_8:
                    return Display.KEY_8;
                case 57:
                case Keyboard.NUMPAD_9:
                    return Display.KEY_9;
                case Keyboard.NUMPAD_MULTIPLY:
                    return Display.KEY_ASTERISK;
                case Keyboard.NUMPAD_SUBTRACT:
                    return Display.KEY_POUND;
                case Keyboard.LEFT:
                    return Display.KEY_LEFT;
                case Keyboard.RIGHT:
                    return Display.KEY_RIGHT;
                case Keyboard.UP:
                    return Display.KEY_UP;
                case Keyboard.DOWN:
                    return Display.KEY_DOWN;
                case Keyboard.ENTER:
                case Keyboard.NUMPAD_ENTER:
                    return Display.KEY_SELECT;
                case Keyboard.NUMPAD_DIVIDE:
                    return Display.KEY_SOFT1;
                case Keyboard.NUMPAD_ADD:
                    return Display.KEY_SOFT2;
            }
            return KEY_NONE;
        }

        //キーダウンイベントの処理
        private function keyDownHandler(evt:KeyboardEvent):void {
            var keyParam:int=calcKeyParam(evt.keyCode);
            if (keyParam==KEY_NONE) return;
            processEvent(Display.KEY_PRESSED_EVENT,keyParam);
        }

        //キーアップイベントの処理
        private function keyUpHandler(evt:KeyboardEvent):void {
            var keyParam:int=calcKeyParam(evt.keyCode);
            if (keyParam==KEY_NONE) return;
            processEvent(Display.KEY_RELEASED_EVENT,keyParam);
        }

        //マウスクリックイベントの処理
        private function clickHandler(evt:MouseEvent):void {
            stage.focus=base;
        }
    }
}