package {
    import flash.text.*;

    //ユーティリティ
    public class Util {
        //ラベルの生成
        public static function makeLabel(x:int,y:int,w:int,h:int,
        	autoSize:String):TextField {
            var label:TextField=new TextField();
            label.selectable=false;
            label.x       =x;
            label.y       =y;
            label.width   =w;
            label.height  =h;
            label.autoSize=autoSize;
            return label;
        }

		//テキストフォーマットの生成
		public static function makeTextFormat(size:uint,color:uint):TextFormat {
            var format:TextFormat=new TextFormat();
            format.font ="_等幅";
            format.size =size;  
            format.color=color;
            format.bold =true;
            return format;
		}

	    //2点間の距離の2乗の計算
	    public static function calcLen(x0:int,y0:int,x1:int,y1:int):int {
	        return (x1-x0)*(x1-x0)+(y1-y0)*(y1-y0);
	    }

		//乱数の取得
        public static function rand(num:uint):int {
            return Math.floor(Math.random()*num);
        }

        //テキストフィールドの追加
        public static function makeTextField(text:String,
        	x:int,y:int,w:int,h:int):TextField {
            var textField:TextField=new TextField();
            textField.x         =x;
            textField.y         =y;
            textField.width     =w;
            textField.height    =h;
            textField.text      =text;
            textField.selectable=true;
            textField.border    =true;
            textField.background     =true;
            textField.backgroundColor=0xFFFFFF;
            textField.type      =TextFieldType.INPUT;
            return textField;
        }

        //文字列を任意の文字で分割
        public static function parseString(str:String,sep:String):Array {
            var i:int,j:int,size:int;
            var result:Array;
            
            //最後尾に分割文字
            if (str.length==0||str.charAt(str.length-1)!=sep) str+=sep;
    
            //サイズを得る
            size=0;
            i=str.indexOf(sep);
            while (i>=0) {
                size++;
                i=str.indexOf(sep,i+1);
            }
    
            //分割する
            result=new Array(size);
            size=0;
            j=0;
            i=str.indexOf(sep);
            while (i>=0) {
                result[size++]=delChar(str.substring(j,i),"\r");
                j=i+1;
                i=str.indexOf(sep,j);
            }
            return result;
        }
        
        //文字の削除
        public static function delChar(str:String,c:String):String {
            var i:int;
            var w:String;
            if (str.indexOf(c)<0) return str;
            w="";
            for (i=0;i<str.length;i++) {
                if (str.charAt(i)!=c) w+=str.charAt(i);
            }
            return w;    
        }
    }
}