package {
    //キャラクター
    public class Character {
		//素材クラス
        [Embed(source='c0.png')]
        private var ImageC0:Class;
        [Embed(source='c1.png')]
        private var ImageC1:Class;

		//素材オブジェクト
        private static var image:Array=new Array(2);

		//変数        
    	private var id:int;         //ID
    	private var type:int;       //種別
    	private var x:int;          //X座標
    	private var y:int;          //Y座標
    	private var toX:int;        //移動先X座標
    	private var toY:int;        //移動先Y座標
    	private var serif:String;   //セリフ
    	private var delFlag:Boolean;//削除フラグ
    	
    	
    	//コンストラクタ
    	public function Character() {
			//素材オブジェクト    		
    		if (image[0]==null) {
                image[0]=new ImageC0();
	            image[1]=new ImageC1();  
    		}

    		//変数
    		id     =Util.rand(10000);
    		type   =Util.rand(2);
    		x      =32+Util.rand(576);
    		y      =72+Util.rand(288);
    		toX    =x;
    		toY    =y;
    		serif  ="";
    		delFlag=false;
    	}
    	
    	//描画
    	public function draw(g:JGraphics):void {
    		//移動
    		if (Math.abs(x-toX)<20) x=toX;
    		if (Math.abs(y-toY)<20) y=toY;
    		     if (toY<y) y-=20;
    		else if (toY>y) y+=20;
    		else if (toX<x) x-=20;
    		else if (toX>x) x+=20;
   		
    		//キャラクターの描画
    		g.drawImage(image[type],x-24,y-48);
    		
    		//セリフの描画
    		if (serif.length>0) {
    			var w:int=g.stringWidth(serif);
    			g.setColor(g.getColorOfName(JGraphics.WHITE));
    			g.fillRect(x-w/2,y-48-16,w,16);
    			g.setFontSize(16);
    			g.setColor(g.getColorOfName(JGraphics.BLACK));
    			g.drawString(serif,x-w/2,y-48);
    		}
    	}
    	
    	//移動先XY座標の指定
    	public function setToXY(toX:int,toY:int):void {
    		if (toX<8+24)     toX=8+24;
    		if (toX>640-8-24) toX=640-8-24;
    		if (toY<48+24)    toY=48+24;
    		if (toY>48*8-24)  toY=48*8-24;
    		this.toX=toX;
    		this.toY=toY;
    	}

    	//IDの取得
    	public function getID():int {
    		return id;
    	}    	
    	
    	//セリフの指定
    	public function setSerif(serif:String):void {
    		this.serif=serif;
    	}
    	
    	//情報の指定
    	public function setInfo(info:Array,init:Boolean=false):void {
    		id     =parseInt(info[0]);
    		type   =parseInt(info[1]);
    		toX    =parseInt(info[2]);
    		toY    =parseInt(info[3]);
    		serif  =info[4];
    		delFlag=false;
    		if (init) {
    			x=toX;
    			y=toY;
    		}
    	}

    	//情報の取得
    	public function getInfo():String {
    		return "?id="+id+"&info="+id+","+type+
    			","+toX+","+toY+","+serif+",END";
    	}
    	
    	//削除フラグの指定
    	public function setDelFlag(delFlag:Boolean):void {
    		this.delFlag=delFlag;
    	}
    	
    	//削除フラグの取得
    	public function getDelFlag():Boolean {
    		return delFlag;
    	}
    }
}